package LCM::Task::Cockpit::XSALogoutHandler;

use strict;
use parent 'LCM::Task::BaseSubtaskFailedHandler';

sub handle {
    my ($self, $task) = @_;
    my $config = $task->_getConfiguration();
    my $xsClient = $config->getXSClient();
    $xsClient->logout(); # Do not leave the XSA in logged-in state
    return 0;            # Still fail
}

sub isApplicable {
    my ($self, $task) = @_;
# We're checking if the task's component is defined because
# the DeployXSAComponentsTask is a component task without a component -_-
	return $task->isComponentTask() && defined $task->getComponent() && $task->isCockpitStackTask();
}

1;