package LCM::Task::ConfigureInternalNetwork::ContinueInternalNetworkSubtask;

use strict;
use File::Spec;
use parent 'LCM::Task::ConfigureInternalNetwork::BaseInternalNetworkSubtask';

# Override
sub getId { return 'continue_configure_internal_network_internal'; }

# Override
sub _executeInternal {
	my $self = shift();
	$self->SUPER::_executeInternal();

	my $config = $self->_getConfiguration();
	my $hdbInstance = $config->getOwnInstance();

	if($self->_shouldDeleteLocalPersistenceFile()){
		$self->_deleteLocalPersistenceFile();
	}
	if(defined($hdbInstance) && $hdbInstance->exists_remote_host()){
		$self->_addWarnings($hdbInstance);
	}
}

sub _shouldDeleteLocalPersistenceFile {
	my ($self) = @_;
	my $config = $self->_getConfiguration();
	my $persistenceFilePath = $config->getPersistenceFilePath();
	my $taskStatus = $self->getStatus();

	return $taskStatus->isInFinishedState() && defined($persistenceFilePath) && -f $persistenceFilePath;
}

sub _deleteLocalPersistenceFile {
	my ($self) = @_;
	my $config = $self->_getConfiguration();
	my $filePath = $config->getPersistenceFilePath();

	$self->getMsgLst()->addMessage("Deleting status file '$filePath'.");
	if ( unlink($filePath) ) {
		$self->getMsgLst()->addMessage("Status file '$filePath' deleted.");
	} else {
		$self->getMsgLst()->addError("Status file '$filePath' was not deleted.");
	}
}

# Override
sub _getHdbToolName {
	return 'hdbreg';
}

# Override
sub _createHdbToolArgs { return [ '-b' ]; }

# Override
sub _getPasswordKeys { return [ 'Password' ]; }

# Override
sub _getNumberOfExpectedOutputLines { return 30; }

sub _addWarnings {
	my ($self, $hdbInstance) = @_;
	my $instanceDir = $hdbInstance->get_instanceDir();
	my $hosts = $hdbInstance->get_hosts();
	my $message = ": Inter-Service Communication configuration is not yet finished. To complete this action, run 'hdblcm --action=configure_internal_network' on host(s): ";
	my $hostsString = '';

	for my $host(@{$hosts}){
		if(-f File::Spec->catfile($instanceDir, $host, "hdblcm_configure_internal_network")){
			$hostsString .= $host . ", ";
		}
	}
	if($hostsString){
		$message .= $hostsString;
		$message = substr($message, 0, length($message) - 2);
		LCM::ExecutionWarningsObservable->getInstance()->notifyWarning($message);
	}
}

# Override
sub _shallCreatePersistenceFile { return 0; }

1;