package LCM::Task::ConfigureInternalNetworkProcessTask;

use strict;
use File::Spec;
use parent 'LCM::Task::SLProcessTask';
use LCM::ExecutionWarningsObservable;
use LCM::Task::ConfigureInternalNetwork::ConfigureInternalNetworkSubtask;
use LCM::Task::ConfigureInternalNetwork::ContinueInternalNetworkSubtask;

my $CONFIGURATION_NAME = 'Inter-Service Communication';
my $ACTION_DONE_MESSAGE = sprintf("%s configured", $CONFIGURATION_NAME);
my $ACTION_DONE_WITH_WARNINGS_MESSAGE = sprintf('%s configured with warnings', $CONFIGURATION_NAME);
my $ACTION_FAILED_MESSAGE = sprintf("Configuration of %s failed", $CONFIGURATION_NAME);
my $ACTION_ABORTED_MESSAGE = sprintf("Configuration of %s aborted",$CONFIGURATION_NAME);

sub new {
	my ($class, $configuration) = @_;
	my $self = $class->SUPER::new($configuration);

	my $status = $self->getStatus();

	$status->_setActionDoneMessage($ACTION_DONE_MESSAGE);
	$status->_setActionDoneWithWarningsMessage($ACTION_DONE_WITH_WARNINGS_MESSAGE);
	$status->_setActionFailedMessage($ACTION_FAILED_MESSAGE);
	$status->_setActionAbortedMessage($ACTION_ABORTED_MESSAGE);

	if($configuration->isa('LCM::Configuration::InternalNetworkContinueConfiguration')) {
		$self->addSubtask(new LCM::Task::ConfigureInternalNetwork::ContinueInternalNetworkSubtask($configuration));
	} else {
		$self->addSubtask(new LCM::Task::ConfigureInternalNetwork::ConfigureInternalNetworkSubtask($configuration));
	}

	return $self;
}

sub getId {
	return 'configure_internal_network';
}

sub getName {
	return sprintf('Configure %s', $CONFIGURATION_NAME);
}

sub _executeInternal {
	my $self = shift();
	LCM::ExecutionWarningsObservable->getInstance()->registerListener($self);
	$self->SUPER::_executeInternal(@_);
	LCM::ExecutionWarningsObservable->getInstance()->unregisterListener($self);
}

#implementing required interface by LCM::ExecutionWarningsObservable
sub onWarning {
	my ($self,$message) = @_;
	$self->_addWarningMessage($message);
}

1;