package LCM::Task::ConvertToMultiDBTask::DisableXSAServicesTask;

use strict;
use LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler;
use LCM::Component::Installed::HDBServer;
use SDB::Install::ServiceManager;
use parent 'LCM::Task::ConvertToMultiDBTask::ConvertServerStateTask';

my  $XSA_SERVICES = ['xsexecagent', 'xscontroller', 'xsuaaserver'];
our $PROGRESS_MESSAGE = "Disabling the XSA services...";
my  $SUCCESS_END_MESSAGE = "Finished disabling the XSA services";
my  $FAIL_END_MESSAGE = "Disabling XSA services failed";

our @EXPORT = qw($PROGRESS_MESSAGE);

sub getId {
    return 'disable_xsa_services_task';
}

sub getName {
    return 'Disabling XSA services';
}

sub getExecutionName {
    return 'Disabling XSA services';
}

sub getSuccessMessage{
    return $SUCCESS_END_MESSAGE;
}
sub getFailedMessage{
    return $FAIL_END_MESSAGE;
}
sub getProgressMessage{
    return $PROGRESS_MESSAGE;
}
sub getServerCurrentConversionState{
    my $self = shift;
    my $configuration = $self->_getConfiguration();
    my $isFinished = $configuration->isServerNoStart() && !$configuration->hasStreaming() ;
    return $isFinished ? LCM::Component::Installed::HDBServer::CONVERT_MDC_FINISHED : LCM::Component::Installed::HDBServer::CONVERT_MDC_STARTED;
}

sub _executeConvertStep{
    my($self,$configuration) = @_;
    my $serviceManager = SDB::Install::ServiceManager->new();
    my $msg = $self->getMsgLst()->addMessage("Disabling ".(join ',', @{$XSA_SERVICES})." via the Service Manager ...");
    $serviceManager->setMsgLstContext([$msg->getSubMsgLst()]);
    if(!$serviceManager->disableServicesInDaemonIni($configuration, $XSA_SERVICES)) {
        $self->setErrorMessage("Couldn't disable the XSA services", $serviceManager->getErrMsgLst());
        return 0;
    }

    return 1;
}

sub _getNumberOfExpectedOutputLines {
    return 50;
}

sub initProgressHandler {
    my ($self) = @_;
    $self->getMsgLst()->setProgressHandler(new LCM::Task::TaskProgressHandler::ConvertToMultiDBTaskProgressHandler($self));
}

1;