package LCM::Task::ExtractComponentsTask::ExtractDownloadedComponentsTask;
use parent qw(LCM::Task::ExtractComponentsTask::ExtractComponentsTask);
use strict;

use experimental qw (smartmatch);

sub _filterArchiveNamesForExtraction {
    my $self = shift;
    my $dirArchiveNames = $self->_listDirBySuffix(@_);
    my $parentProcessTask = $self->getParentTask();
    my $downloadedArchiveNames = $parentProcessTask->getDownloadedArchiveNames();
    return [] if (!defined $downloadedArchiveNames);
    my @filteredArchives = grep {$_ ~~ @$downloadedArchiveNames} @$dirArchiveNames;
    return \@filteredArchives;
}

1;
