package LCM::Task::GenericStackTask::CollectReferenceDatas;

use strict;
use parent 'LCM::Task';

sub _executeInternal {
    my $self = shift;
    my $configuration = $self->_getConfiguration();
    $configuration->{referenceDataList} = [];
    for my $component (@{ $self->getParentTask()->getSelectedComponents()}) {
        if($component->getManifest()->isReferenceData()){
            push @{$configuration->{references_list}}, $component->getComponentKeyName();
        }
    }
    $self->getStatus()->_setFinishedState();
}

sub getId {
    return 'collect_reference_datas';
}

sub getName{
    return 'Collect Address Directories and Reference Data';
}

sub getExecutionName{
    return 'Collecting Address Directories and Reference Data';
}

sub _getNumberOfExpectedOutputLines{
    return 0;
}

sub isHidden{
    return 1;
}

sub shouldBeShownOnSummaryPage {
    return 0;
}

1;
