package LCM::Task::GenericStackTask::ComponentTasklistFactory::ComponentTasklistFactoryInstall;

use strict;
use warnings;
use experimental qw (smartmatch);
use parent 'LCM::Task::GenericStackTask::ComponentTasklistFactory::ComponentTasklistFactoryBase';
use LCM::Task::GenericStackTask::ComponentTask;
use LCM::Task::GenericStackTask::ComponentTask::ComponentPhasedTask;
use LCM::Component qw(PREPARE_PHASE OFFLINE_PHASE);
use SDB::Install::Globals qw($gHostRoleWorker);


sub createComponentTasklist {
    my ($self) = @_;
    my $config = $self->getConfiguration();
    my $components = $config->getComponentManager()->getSelectedComponents();

    if ($config->isOptimizedExecution()) {
        return $self->_createPhasedTasklist($components);
    }

    return $self->_createDefaultTasklist($components);
}

# Nothing will be executed in separate prepare phase during installation
sub _createPrepareTasklist {
    my ($self, $components) = @_;
    return [];
}

# During phased install, only the local HANA host must be started before the online phase
sub _getInstancesToStartBeforeOnlinePhase {
    my ($self, $components) = @_;
    my $configuration = $self->getConfiguration();
    return [ $configuration->getLocalHanaHost() ];
}

# During phased system installation, we cannot distinguish between prepare and offline phase, so
# we execute the prepare and the offline phase of all components together.
sub _createOfflineTasklist {
    my ($self, $components) = @_;
    my $configuration = $self->getConfiguration();
    my $offlineTasklist = [];

    for my $component (@{$components}) {
        for my $phase (PREPARE_PHASE, OFFLINE_PHASE) {
            next if $component->isPostAddHostsComponent();
            next if !$component->canBeCalledInPhase($phase, $configuration);

            if ($component->supportsPhase($phase)) {
                push(@{$offlineTasklist}, LCM::Task::GenericStackTask::ComponentTask::ComponentPhasedTask->new($configuration, $component, $phase));
            } else {
                push(@{$offlineTasklist}, LCM::Task::GenericStackTask::ComponentTask->new($configuration, $component));
            }
        }
    }

    return $offlineTasklist;
}

sub _getHostsWithRoles {
    my ($self, $roles) = @_;
# During phased installation, while the component tasks are executed, only one hosts exists -
# the local HANA host, which has the 'worker' roles. All other roles and hosts are added on
# later stage.
    if (grep { $_ eq $gHostRoleWorker } @{$roles}) {
        return [ $self->getConfiguration->getLocalHanaHost() ];
    }
    return [];
}

1;