package LCM::Task::GenericStackTask::Listeners::PersistServerInstallTaskListener;
use strict;

use parent qw ( LCM::Task::GenericStackTask::Listeners::PersistTaskListener );
use LCM::PersistencyUtils qw ( existsHdbinstPendingInstall );

sub notifyTaskChanged{
    my ($self, $task) = @_;
    if ( $self->shallPersistState( $task ) ) {
    	$self->SUPER::notifyTaskChanged( $task );
    }
}

sub shallRemovePersistenceFile {
	my($self,$task) = @_;
	return $self->SUPER::shallRemovePersistenceFile($task, \&existsHdbinstPendingInstall );
}

sub shallPersistState {
	my($self,$task) = @_;

	my $target = $task->_getConfiguration()->getValue('Target');
	my $sid = $task->_getConfiguration()->getValue('SID');
	my $directory = File::Spec->catdir($target,$sid);
	if ( ! -d $directory ) {
		return 0;
	}

	my $status = $task->getStatus();
	return $status->isInRunningState() || $status->isInFinishedState() || $status->isInErrorState() || $status->isInAbortedState(); 
}

1;
