package LCM::Task::GenericStackTask::Listeners::PersistTaskListener;
use strict;

use parent qw ( LCM::Task::BaseTaskListener );

use File::Basename qw(dirname);
use LCM::Component;
use Cwd qw (realpath);

sub notifyTaskChanged{
    my ($self, $task) = @_;
    my $taskState = '';
    if ( defined $self->_getTaskState() ) {
    	$taskState = $self->_getTaskState();
    }
    my $isStatusChanged = !$task->getStatus()->isInInitialState() && $task->getStatus()->getState() ne $taskState;

    return if(!$isStatusChanged);

    $self->_setTaskState( $task->getStatus()->getState() );
    if($self->shallRemovePersistenceFile($task)){
        $self->_removePersistenceFile($task);
    } else {
        $self->_persistProcessState($task);
    }
}

sub _setTaskState {
    $_[0]->{_taskStatus} = $_[1];
}

sub _getTaskState {
    return $_[0]->{_taskStatus};
}

sub _persistProcessState{
    my ($self,$task) = @_;
    if(!defined $task){
        return;
    }

    my $configuration = $task->_getConfiguration();
    my $process = $task->getParentTask();
    my $currentTask = $process->getCurrentTask();
    
    $configuration->setMsgLstContext($task->getMsgLstContext());
    $configuration->setStepName($currentTask->getName());
    my $mcm = $configuration->getComponentManager();
    if (defined $mcm) {
        my $componentDirs = $mcm->getComponentDirs(1);
        $configuration->{'params'}->{'ComponentDirs'}->{'value'} = join(',', @{$componentDirs});
    }
    $configuration->getPersistenceManager()->registerTimeoutsToPersist();
    $configuration->getPersistenceManager()->registerIgnoreOptionsToPersist();
    my $index = $process->indexOf($currentTask->getId());
    #Step are expected to start from 1
    $configuration->setStep($index+1);

}

sub shallRemovePersistenceFile{
    my($self,$task, $subroutineReference) = @_;
    my $taskFinished = $task->getStatus()->isInFinishedState() || $task->getStatus()->isInErrorState() || $task->getStatus()->isInAbortedState();

    return 0 if(!$taskFinished);

	my $configuration = $task->_getConfiguration();
	my $sid = $configuration->getSID();
	my $existsHdbPersistenceFile = $subroutineReference->($sid, $configuration->getValue('Target'));
	my $isServerComponentSelected = $configuration->getComponentManager()->isHDBServerComponentSelected();

	return ($existsHdbPersistenceFile && $isServerComponentSelected) ? 0 : 1;
}

sub _removePersistenceFile {
    my ($self,$task) = @_;
    my $configuration = $task->_getConfiguration();

    my $persistenceFileName = $configuration->pers_filename();
    $configuration->setMsgLstContext($task->getMsgLstContext());
    return 1 if (!$configuration->getStep());
    return 1 if (!defined $persistenceFileName);

    if (!defined $configuration->pers_remove()) {
        $task->setErrorMessage('Unable to remove persistence file ',
                                $configuration->getErrMsgLst());
        return 0;
    }

    return 1;
}

1;
