package LCM::Task::GenericStackTask::PersistScopeInstanceValuesTask;

use strict;
use parent 'LCM::Task';

sub getId {
	return 'persist_scope_instance_values';
}

sub getName{
	return 'Persist Scope Instance Values';
}

sub getExecutionName{
	return 'Persisting Scope Instance Values';
}

sub _executeInternal {
	my $self = shift;
	my $configuration = $self->_getConfiguration();
    my $rc = $configuration->persistValuesForScopeInstance();
       if (!$rc) {
            $self->getStatus()->_setErrorState();
            $self->setErrorMessage( undef, $configuration->getErrMsgLst() );
            return;
       }
    $self->getStatus()->_setFinishedState();
}

sub _getNumberOfExpectedOutputLines{
    return 0;
}

sub isHidden{
	return 1;
}

sub shouldBeShownOnSummaryPage {
  return 0;
}

1;
