package LCM::Task::GenericStackTask::PostSystemOnlinePhaseTaskGenerator;
use parent 'LCM::Task::TaskGenerator';
use strict;

use SDB::Install::Globals qw($gKeynameEngine);
use LCM::Task::ConvertToMultiDBTask::ForceSystemDBUserPasswordChangeTask;

sub createTaskList{
    my($self, $configuration) = @_;
    my $result = [];

    my $server = $configuration->getSystemComponentManager()->getComponentByKeyName($gKeynameEngine);
    my $isConvertToMDCStarted = defined $server ? $server->isConvertToMDCStarted() : 0;
    my $isConvertToMDC = $configuration->isConvertToMultiDbRequired() || $isConvertToMDCStarted;
    return $result if (!$isConvertToMDC);
    return $result if ($configuration->getValue('SystemUser') eq 'SYSTEM');
    return $result if $configuration->isSystemDBSQLPasswordSetByUser();
    return $result if $configuration->getValue('SystemDBUseSingleDBUserPassword');
    push (@$result, LCM::Task::ConvertToMultiDBTask::ForceSystemDBUserPasswordChangeTask->new($configuration));

    return $result;
}

1;