package LCM::Task::RemoveHostRolesProcessTask;
use parent qw (LCM::Task::SLProcessTask);
use strict;

use LCM::Task::CommonTask::RemoveLocalRolesTask;
use LCM::Task::CommonTask::RemoveRemoteRolesTask;
use LCM::Task::CommonTask::RemoveRemoteXsControllerRolesTask;

my $ACTION_DONE_MESSAGE = "Specified host roles successfully removed";
my $ACTION_DONE_WITH_WARNINGS_MESSAGE = "Specified host roles removed with warnings.";
my $ACTION_FAILED_MESSAGE = "Removal of host roles failed.";
my $ACTION_ABORTED_MESSAGE = "Removal of host roles aborted.";


sub new{
    my ($class, $configuration) = @_;
    my $self = $class->SUPER::new($configuration);
    my $status = $self->getStatus();
    $status->_setActionDoneMessage($ACTION_DONE_MESSAGE);
    $status->_setActionDoneWithWarningsMessage($ACTION_DONE_WITH_WARNINGS_MESSAGE);
    $status->_setActionFailedMessage($ACTION_FAILED_MESSAGE);
    $status->_setActionAbortedMessage($ACTION_ABORTED_MESSAGE);
    return $self;
}

sub _createSubtasks {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();
# Makes sure xscontroller host's xs_worker role would
# always be removed last when removing all xs_workers
    if ($configuration->isLocalHostXsController()) {
        $self->_removeRemoteFirstSubtaskOrder();
    } else {
        $self->_removeLocalFirstSubtaskOrder();
    }
}

sub _removeRemoteFirstSubtaskOrder {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();
    if ($configuration->isRemovingRemoteHostRoles()) {
        $self->addSubtask(new LCM::Task::CommonTask::RemoveRemoteRolesTask($configuration));
    }
    if ($configuration->isRemovingLocalHostRoles()) {
        $self->addSubtask(new LCM::Task::CommonTask::RemoveLocalRolesTask($configuration));
    }
}

sub _removeLocalFirstSubtaskOrder {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();
    if ($configuration->isRemovingLocalHostRoles()) {
        $self->addSubtask(new LCM::Task::CommonTask::RemoveLocalRolesTask($configuration));
    }
    if ($configuration->isRemovingRemoteHostRoles()) {
        $self->addSubtask(new LCM::Task::CommonTask::RemoveRemoteRolesTask($configuration));
    }
    if ($configuration->shouldRemoveXsControllerHostRolesSeparately()) {
        $self->addSubtask(new LCM::Task::CommonTask::RemoveRemoteXsControllerRolesTask($configuration));
    }
}

sub _executeInternal {
    my $self = shift();
    $self->_createSubtasks();
    $self->SUPER::_executeInternal(@_);
}

sub getId {
    return "remove_host_roles";
}

sub getName {
    return "Remove host roles";
}

1;