package LCM::Task::StartStopHostsTask::EnableSpecificServicesTask;
use parent qw(LCM::Task::StartStopHostsTask::StartStopSpecificServicesBase);
use strict;

use SDB::Install::ServiceManager;

sub getId {
	my ($self) = @_;
	return 'enable_services';
}

sub getName {
	my ($self) = @_;
	return "Enable services";
}

sub getExecutionName {
	my ($self) = @_;
	return "Enabling services";
}

sub _manageServices {
	my ($self) = @_;
	my $serviceManager = SDB::Install::ServiceManager->new();
	$serviceManager->setMsgLstContext($self->getMsgLstContext);
	my $config = $self->_getConfiguration();
	return $serviceManager->enableServicesInDaemonIni($config, $self->getServices());
}

1;
