package LCM::Task::StartStopHostsTask::StartSpecificServicesTask;
use parent qw(LCM::Task::StartStopHostsTask::StartStopSpecificServicesBase);
use strict;

use SDB::Install::ServiceManager;

sub getId {
	my ($self) = @_;
	return 'start_services';
}

sub getName {
	my ($self) = @_;
	return 'Start services';
}

sub getExecutionName {
	my ($self) = @_;
	return 'Starting services';
}

sub _manageServices {
	my ($self) = @_;
	my $serviceManager = SDB::Install::ServiceManager->new();
	$serviceManager->setMsgLstContext($self->getMsgLstContext);
	my $config = $self->_getConfiguration();
	return $serviceManager->startServices($config, $self->getServices());
}

1;
