package LCM::Task::StartStopHostsTask::StartStopHostsTaskBase;

use strict;

use parent 'LCM::Task::GenericStackTask::ComponentTask';

use SDB::Install::SysVars qw($isWin);
use SDB::Install::SAPInstance::TrexInstance;
use SDB::Install::NewDBUser;
use LCM::Task::StartStopHostsTask::DummyStartStopHostsComponent;

sub new {
	my ($class, $configuration,$component,$noResume) = @_;
	my $self = $class->SUPER::new($configuration, new LCM::Task::StartStopHostsTask::DummyStartStopHostsComponent(undef, undef, undef, $configuration),$noResume);

	return $self;
}

sub _executeInternal {
	my ($self) = @_;
	my $configuration = $self->_getConfiguration();
	my $hdbInstance = $configuration->getOwnInstance();

	if (!defined $hdbInstance) {
		$self->getErrMsgLst()->addMessage('Unable to get HDB Instance');
		$self->getStatus()->_setErrorState();
		return;
	}

	my $message = $self->getMsgLst()->addProgressMessage($self->getExecutionName(). "...");
	my $saveContext = $self->setMsgLstContext([$message->getSubMsgLst()]);

	$hdbInstance->setMsgLstContext($self->getMsgLstContext());

	my $sid = $hdbInstance->get_sid();
	my $user = new SDB::Install::NewDBUser($sid);
	my $sidAdmUser = $user->getSidAdm();
	my $userName = $sidAdmUser->getname();
	my $password = $configuration->getValue('Password');
	my $startTimeout = $configuration->getTimeout ('start_instance');
	my $stopTimeout = $configuration->getTimeout ('stop_instance');
	my $useHttps = $configuration->isUseHttps();

	if ($self->_manageSystem($hdbInstance, $userName, $password, $startTimeout, $stopTimeout, $useHttps)) {
		$self->getStatus()->_setFinishedState();
		$message->endMessage (undef, sprintf("%s finished", $self->getName()));
	} else {
		$self->getStatus()->_setErrorState();
		$message->endMessage (undef, sprintf("%s failed", $self->getName()));
	}

	$self->setMsgLstContext($saveContext);
}

sub _addListeners {
	my ($self) = @_;
	$self->{_listeners} = [];
}

sub _manageSystem {
	...
}

sub _getNumberOfExpectedOutputLines {
	return 50;
}

sub shouldBeShownOnSummaryPage {
	return 0;
}

1;
