package LCM::Task::TaskProgressHandler::ComponentTaskProgressHandlerFactory;

use strict;
use warnings;
use LCM::Task::TaskProgressHandler;
use LCM::Task::TaskProgressHandler::ResidentInstallerTaskProgressHandler;
use LCM::Task::TaskProgressHandler::XSATaskProgressHandler;
use SDB::Install::Globals qw ($gKeynameInstaller);

sub createComponentTaskProgressHandler {
    my ($task) = @_;
    my $component = $task->getComponent();

    if ($component && $component->isInstaller()) {
        return LCM::Task::TaskProgressHandler::ResidentInstallerTaskProgressHandler->new($task);
    } elsif($component && $component->isXS2()) {
        return LCM::Task::TaskProgressHandler::XSATaskProgressHandler->new($task);
    }else {
        return LCM::Task::TaskProgressHandler->new($task);
    }
}

1;