package LCM::Task::TaskProgressHandler::UpdateHostProgressHandler;

use strict;
use parent 'LCM::Task::TaskProgressHandler';
use LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfiguration qw($PROGRESS_MSG_FILTER $PROGRESS_MSG_FILTER_REMOTE);

sub addLine {
    my($self, $progressMessage) = @_;
    $self->SetProgress($progressMessage);
}

sub SetProgress {
    my ($self, $progressMessage) = @_;
    if ($progressMessage =~ /$PROGRESS_MSG_FILTER/ || $progressMessage =~ /$PROGRESS_MSG_FILTER_REMOTE/) {
        $progressMessage = ("  " x $self->getIndentationDepth()).$progressMessage;
        $self->_getTask()->_addProgressMessage($progressMessage);
    }
}

1;