package LCM::Task::UpdateComponentListProcessTask;

use strict;
use parent 'LCM::Task::SLProcessTask';
use LCM::Task::CLIProcessTaskMetadata;
use LCM::Task::CommonTask::UpdateComponentListTask;

my $SUCCESS_END_MESSAGE = "Component list updated";
my $FAIL_END_MESSAGE = "Update of component list failed.";
my $ABORT_END_MESSAGE = "Update of component list aborted.";

sub new {
    my ($class, $config) = @_;
    my $self = $class->SUPER::new($config);
    $self->_setCLIMetadata(LCM::Task::CLIProcessTaskMetadata->new({
        requiresInput           => 0,
        requiresSummary         => 0,
        messageBeforeConfirm    => "Component list will be updated with the detected components on the system.",
    }));
    my $status = $self->getStatus();
    $status->_setActionDoneMessage($SUCCESS_END_MESSAGE);
    $status->_setActionFailedMessage($FAIL_END_MESSAGE);
    $status->_setActionAbortedMessage($ABORT_END_MESSAGE);
    $self->_addSubtasks();
    return $self;
}

sub getId {
    return "update_component_list_process_task";
}

sub getName {
    return "Update component list";
}

sub _addSubtasks {
    my ($self) = @_;
    my $config = $self->_getConfiguration();
    $self->addSubtask(LCM::Task::CommonTask::UpdateComponentListTask->new($config));
}

## Don't gather SL Analytics data for this action
sub _startSLAnalyticsMonitor {
    return 1;
}

sub _stopSLAnalyticsMonitor {
    return 1;
}

1;