package LCM::TraceLoggingEnvironment;

use strict;
use SDB::Install::SysVars qw($path_separator);
use File::Basename qw (dirname basename);


sub PrepareComponentHdbInstallerEnvironment{
    my ($component, $componentKeyName) = @_;
    my %env = %ENV;
    if(!defined $component){
        return \%env;
    }
    if (!defined $componentKeyName){
        $componentKeyName = $component->getComponentBatchKey ();
    }
    return _prepareHdbInstallerExtension($componentKeyName)

}

sub PrepareProcessExecutorHdbEnvironment{
    my ($command) = @_;
    my %env = %ENV;
    if (!defined $command){
        return \%env;
    }
    $command = basename ($command);
    return _prepareHdbInstallerExtension($command);
}

sub _prepareHdbInstallerExtension{
	my ($extension) = @_;
	my %env = %ENV;
	$extension = '_' . $extension;
    my ($fileName, $basename);
    my @extensionList;
    foreach my $varName ('HDB_INSTALLER_TRACE_FILE', 'SDBINSTLOGFILE'){
        if (!defined $env{$varName} || !$env{$varName}){
            next;
        }
        $fileName = $env{$varName};
        $basename = basename ($fileName);
        @extensionList = split ('\.', $basename);
        if (@extensionList < 2){
            $env{$varName} = $fileName . $extension;
            next;
        }
        $extensionList[@extensionList - 2] .= $extension;
        $env{$varName} = dirname ($fileName) . $path_separator .
            join ('.', @extensionList);
    }
    return \%env;
}

return 1;
