package LCM::Utils::ComponentActionStringGenerator;

use strict;
use SDB::Install::Version;
use SDB::Install::Globals qw ($gKeynameEngine
                              $gKeynameClient
                              $gKeynameStudio
                              $gKeynameAFL
                              $gKeynameLCA
                              $gKeynameHLM
                              $gKeynameSDA
                              $gKeynameStreaming
                              $gKeynameEs
                              $gKeynameAccelerator
                              $gKeynameXS2
                              $gKeynameLSS);

our $keynameToSortKey = {
    # SAP HANA internal components
        $gKeynameEngine       => 0,

        $gKeynameClient       => 1,
        $gKeynameStudio       => 1,
        $gKeynameLSS         => 1,

        $gKeynameSDA          => 2,

    # SAP HANA XS Advanced Runtime
        $gKeynameXS2          => 3,

    # SAP HANA options
        $gKeynameEs           => 4,
        $gKeynameAccelerator  => 4,
        $gKeynameStreaming    => 4,

    # SAP HANA AFLs
        $gKeynameAFL          => 5,

    # Misc components
        $gKeynameLCA          => 6,
        $gKeynameHLM          => 6,

    # Future unknown
        '_UNKNOWN'            => 100,
};

sub sortKeynamesByBatchKey {
	my ($firstKeyname, $secondKeyname, $componentManager, $systemComponentManager) = @_;

	sub getComponent {
		my ($keyname, $componentManager, $systemComponentManager) = @_;
		my $component;
		if ( defined $componentManager ){
			$component = $componentManager->getComponentByKeyName($keyname);
			return $component if defined $component;
		}
		return $systemComponentManager->getComponentByKeyName($keyname);
	}
	sub getSortKey {
		my ($keyname, $component) = @_;
		return $keynameToSortKey->{$keyname} if exists $keynameToSortKey->{$keyname};
		return $keynameToSortKey->{$gKeynameAFL} if $keyname =~ /AFL/;
		return $keynameToSortKey->{'_UNKNOWN'};
	}

	my $firstComponent = getComponent( $firstKeyname, $componentManager, $systemComponentManager );
	my $secondComponent = getComponent( $secondKeyname, $componentManager, $systemComponentManager );

	my $firstSortKey = getSortKey ( $firstKeyname, $firstComponent );
	my $secondSortKey = getSortKey ( $secondKeyname, $secondComponent );

	return $firstSortKey <=> $secondSortKey if $firstSortKey ne $secondSortKey;
	return $firstComponent->getComponentBatchKey() cmp $secondComponent->getComponentBatchKey();
}

sub new {
	return bless({}, shift());
}

sub getComponentKeynameToActionMap {
	...
}

sub getOrderedKeynames {
	my ($self, $componentKeynameToActionMap, $componentManager, $systemComponentManager) = @_;
	my @orderedKeynames = sort { sortKeynamesByBatchKey($a, $b, $componentManager, $systemComponentManager) } keys %{$componentKeynameToActionMap};
	return \@orderedKeynames;
}
1;