package LCM::Utils::ComponentActionStringGenerator::WebUninstall;

use strict;
use LCM::Component;
use parent 'LCM::Utils::ComponentActionStringGenerator::Uninstall';

sub getComponentKeynameToActionMap {
    my ($self, $configuration, $componentManager, $systemComponentManager) = @_;
    my %componentKeynameToAction = ();

    foreach my $component (@{$systemComponentManager->getAllComponents()}){
        next if !$component->canBeSelectedForUninstall();

        my $componentName = $component->getComponentName();
        my $versionString = $component->getVersion();
        my $keyname = $component->getComponentKeyName();
        $componentKeynameToAction{$keyname} = sprintf('Name: %s VersionInfo: version %s', $componentName, $versionString);
    }

    my $orderedKeynames = $self->getOrderedKeynames(\%componentKeynameToAction, $componentManager, $systemComponentManager);
    return ( $orderedKeynames, \%componentKeynameToAction );
}

1;