package LCM::Utils::PrintToFileHandler;

use strict;
use parent 'SDB::Install::ProgressHandler';

sub new {
    my ($class, $fileHandle) = @_;
    my $self = $class->SUPER::new();
    $self->setFilehandle($fileHandle);

    return $self;
}

sub setFilehandle {
    my ($self, $fileHandle) = @_;
    $self->{fileHandle} = $fileHandle;
}

sub getFilehandle {
    my ($self) = @_;
    return $self->{fileHandle};
}

sub addLine {
    my ($self, $line) = @_;
    my $fileHandle = $self->getFilehandle();
    return if !$fileHandle;

    $fileHandle->print("$line\n");
    $fileHandle->flush();
}

sub SetProgress {
    shift->addLine(@_);
}

1;