#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 

package SAPDB::Install::BuildInfo;

require Exporter;

our @ISA = qw (Exporter);
our @EXPORT = qw (GetBuild GetBuildInfo GetMagicString);

bootstrap SAPDB::Install::BuildInfo;

sub AUTOLOAD {
	die unless ($AUTOLOAD =~ /bootstrap$/);

	require XSLoader;
	XSLoader::load (__PACKAGE__);
}

sub GetBuild {
	my  $BUILDINFO = GetBuildInfo (shift);
	return () unless defined ($BUILDINFO->{'Build'});
	return @{$BUILDINFO->{'Build'}};
}

#
# main
#
sub main {
	return (SAPDB::Install::BuildInfo::Test::main (@_));
}

package SAPDB::Install::BuildInfo::Test;


use Getopt::Long;

sub main {
	my ($filename,$outfile) = @_;

	unless (defined $filename) {
		print "BuildInfo <filename>\n";
		return 0;
	}

	my $buildinfo = SAPDB::Install::BuildInfo::GetBuildInfo ($filename);
	if(defined $outfile){
		open(MYFD,'>'.$outfile) or return -1;
	}
	else{
		*MYFD = STDOUT;
	}	
	
	print MYFD $filename.":\n";
	while (my ($key, $val) = each (%$buildinfo)) {
		if (ref ($val) eq 'ARRAY') {
			print MYFD "  ".$key.": ".join ('.', @$val)."\n";
		} elsif (ref ($val) eq 'HASH') {
			while (my ($subkey, $subval) = each %$val) {
				print MYFD "  ".$key.".".$subkey.": ".$subval."\n";
			}
		} else {
			print MYFD "  ".$key.": ".$val."\n";
		}
	}
	close(MYFD) if defined $outfile;
	return 0;
}

1;

