#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 

package SAPDB::Install::DataDumper;

bootstrap SAPDB::Install::DataDumper;

require Exporter;
our @ISA = qw(Exporter);

our @EXPORT = qw (readDump dumpit struct2string string2struct);

use SAPDB::Install::Version;

our ($buf,$string);

our $DEBUG = 0;

sub mask ($){

        # mask data values before dumping it; dump ascii file
		*string = $_[0];
		${$_[0]}=~s/\(/\\\(/g; # ( -> \(     delimiter for struct types ARRAY/HASH/REF/SCALAR
        $string=~s/\)/\\\)/g; # ) -> \)     delimiter for struct types ARRAY/HASH/REF/SCALAR
        $string=~s/"/\\"/g;   # " -> \"     delimiter for values (scalars) and hash keys ""         
        $string=~s/;/\\;/g;   # ; -> \;     seperator for array and hash elements ";;" 
        return 1;
}


sub dumpElement_PERL{
        # recursive sub dump struct elements
        *buf = $_[1];
		my $dumplen=0;	 	
        if(ref($_[0]) eq 'REF'){
               	$buf .= 'REF(';
                $dumplen=dumpElement_PERL(${$_[0]},$_[1]);
                $buf .= ')';
        		$dumplen += 5;
		}
        elsif(ref($_[0]) eq 'HASH'){
				$buf .= 'HASH(';
                $dumplen += 5;
				my $first=1;
				my $writekey;
                foreach my $key (keys(%{$_[0]})){
                        if($first){
                                $first=0;
                        }
                        else{
                                $buf .= ';;';
                        	$dumplen += 2;
						}
                        $writekey=$key;
                        $writekey=~s/\(/\\\(/g; # ( -> \(     delimiter for struct types ARRAY/HASH/REF/SCALAR
                        $writekey=~s/\)/\\\)/g; # ) -> \)     delimiter for struct types ARRAY/HASH/REF/SCALAR
                        $writekey=~s/"/\\"/g;   # " -> \"     delimiter for values (scalars) and hash keys ""         
                        $writekey=~s/;/\\;/g;   # ; -> \;     seperator for array and hash elements ";;" 
                        $buf .="\"\"$writekey\"\" => ";
                        $dumplen += length($writekey) + 8; 
						$dumplen += dumpElement_PERL($_[0]->{$key},$_[1]);
                }
                $buf .=  ')';
				$dumplen++;	
        }
        elsif(ref($_[0]) eq 'ARRAY'){
			    $buf .= 'ARRAY(';
                my $first=1;
                foreach my $element (@{$_[0]}){
                        if($first){
                                $first=0;
                        }
                        else{
                            $buf .= ';;';
                        	$dumplen += 2;
						}
                        $dumplen += dumpElement_PERL($element,$_[1]);
                }
                $buf .=  ')';
        	$dumplen++;
		}
        elsif(ref($_[0]) eq 'SCALAR'){
			    $buf .=  'SCALAR(';
                $dumplen += dumpElement_PERL(${$_[0]},$_[1]);
                $buf .= ')';
        	$dumplen += 8; 
		}
        elsif(!ref($_[0])){
				if(defined $_[0]){
					my $struct_ref = $_[0];
					$struct_ref=~s/\(/\\\(/g; # ( -> \(     delimiter for struct types ARRAY/HASH/REF/SCALAR
					$struct_ref=~s/\)/\\\)/g; # ) -> \)     delimiter for struct types ARRAY/HASH/REF/SCALAR
					$struct_ref=~s/"/\\"/g;   # " -> \"     delimiter for values (scalars) and hash keys ""         
					$struct_ref=~s/;/\\;/g;   # ; -> \;     seperator for array and hash elements ";;" 
					$buf .= '""'.$struct_ref.'""';
					$dumplen += length($struct_ref) + 4;
				}
				else{
					$buf .= "undef";
					$dumplen += 5;
				}	
        }
        else{
		 	$buf .= ref($_[0]);
			$dumplen += length(ref($_[0])); 	
        }
		return $dumplen;	
}


sub dumpit{
        # this sub create dump file; call recursive dump function
		# return number of written bytes
        my ($struct_ref,$file_ref,$truncate)=@_;  #file_ref -> reference to file handle or file name
        my $len=0;
		my $buf = '';
		if(ref($file_ref) eq 'SCALAR'){
			open(dumpFD,">$$file_ref") or print STDERR "ERR: DataDumper::dumpit(): data dump error - cannot create file \"$$file_ref\"\n" and return(0);
			$len=dumpElement($struct_ref,\$buf);
			syswrite (dumpFD, $buf);
			close(dumpFD);
		}
		elsif(ref($file_ref) eq 'GLOB'){
			defined fileno($file_ref) or print STDERR "dumpit(): no valid file handle\n" and return 0;
			seek($file_ref,0,0) or print STDERR "cannot seek to BOF: $!\n" and return 0;
			$len = dumpElement($struct_ref,\$buf);
			syswrite ($file_ref, $buf);
			$len=sysseek($file_ref, 0, 1);
			if($truncate){
				truncate($file_ref, $len) or print STDERR "dumpit(): cannot truncate file\n" and return 0;
			}
		}
		else{
			print STDERR "dumpit(): param error - no filename or file handle\n";
			return 0;
		}
		return($len);
}






sub splitParseString ($){
        # sub is used by getElement; split current struct into substructs 
        my @returnlist;
        my $cons;
        my $cnt1=0; # number of "("
        my $cnt2=0; # number of ")"

        foreach my $element (split(';;',${$_[0]})){
                $cnt1 += () = $element=~/[^\\]\(/g;
                
                #$cnt1 += $element=~s/\(/\(/g; # count "("
                #$cnt1 -= $element=~s/(\\\()/$1/g; # minus masked "("
                				
                $cnt2 += () = $element=~/\)/g; # count ")"
                $cnt2 -= () = $element=~/\\\)/g; # minus masked ")"
                
                #$cnt2 += () = $element=~/(?=([^\\]\)))/g;
	

                my $sep;
                if($cons eq ''){
                        $sep='';
                }
                else{
                       $sep=';;';
                }
                $cons.="$sep$element";
                if($cnt1==$cnt2){
                        push @returnlist,$cons;
                        $cons='';
                        $cnt1=0;
                        $cnt2=0;
                }
        }
        if($cons){
                defined $SAPDB::Install::Values::log && 
                        $SAPDB::Install::Values::log->SetMsg("ERR: DataDumper::splitParseString(): cannot restore data from dump - error parsing dump string\n");
                return undef;
        }
        return @returnlist;
}


sub getElement_PERL{
        # sub parse dumpstring and create struct elements in memory
		my $anything;
		*string = $_[0];
		if($string =~ /^ARRAY\((.*)\)$/s){
               	$1 eq '' and return [];
				my @array=splitParseString(\$1);
                my @returnvalue;
				foreach my $element (@array){
                        $anything=getElement_PERL(\$element);
                        push @returnvalue,$anything;
                }
                return \@returnvalue;
        }
        elsif($string =~ /^HASH\((.*)\)$/s){
				$1 eq '' and return {};
				$anything = $1;
				my @array=splitParseString(\$anything);
                my %returnhash;
				my $key;
				foreach my $element (@array){
                        $_=$element;
                        if (!/^""(.*?)""\s*=>\s*(\S.*)$/s){
							defined $SAPDB::Install::Values::log && 
								$SAPDB::Install::Values::log->SetMsg("ERR: DataDumper::getElement(): error parsing dump file - wrong hash format\n");
							return undef;
                        }
                        $key=$1;
                        $key=~s/\\;/;/g;    # \; -> ;
                        $key=~s/\\"/"/g;    # \" -> "
                        $key=~s/\\\)/\)/g;  # \) -> )
                        $key=~s/\\\(/\(/g;  # \( -> (
                        #demask(\$key);
                        $anything = $2;
						$anything=getElement_PERL(\$anything);
                        $returnhash{$key}=$anything;
				}
                return \%returnhash;
        }
        elsif($string =~ /^REF\((.*)\)$/s){
				$anything = $1;
                $anything=getElement_PERL(\$anything);
                return \$anything;
        }
        elsif($string =~ /^SCALAR\(""(.*)""\)$/s){
                my $scalar_value=$1;
                $scalar_value=~s/\\;/;/g;    # \; -> ;
                $scalar_value=~s/\\"/"/g;    # \" -> "
                $scalar_value=~s/\\\)/\)/g;  # \) -> )
                $scalar_value=~s/\\\(/\(/g;  # \( -> (
                #demask(\$scalar_value);
				#$scalar_value=~s/\\"/\\\\"/g;
				#$scalar_value=~/::ind.*longfile/si and print ${\$scalar_value}."\n";
				return \$scalar_value;
        }
        elsif($string =~ /^""(.*)""$/s){
                my $value=$1;
                $value=~s/\\;/;/g;    # \; -> ;
                $value=~s/\\"/"/g;    # \" -> "
                $value=~s/\\\)/\)/g;  # \) -> )
                $value=~s/\\\(/\(/g;  # \( -> (
				#demask(\$value);
				return $value;
        }
        elsif($string =~ /^undef$/g){
			return undef;
		}
		else{
			defined $SAPDB::Install::Values::log && 
				$SAPDB::Install::Values::log->SetMsg("ERR: DataDumper::getElement(): error parsing dump file - unknown member \"$_\"\n");
        }
}

if (exists $ENV{SDB_USE_DUMPER_PERL} &&
	!exists $ENV{SDB_USE_DUMPER_XS}){
	*dumpElement = \&dumpElement_PERL;
	*getElement = \&getElement_PERL;
}

sub struct2string;
*struct2string = \&dumpElement;

sub string2struct;
*string2struct = \&getElement;

sub readDump{
		# sub return
		my ($file_ref)=@_; #file_ref -> reference to file handle or file name
		my $dump_string;
        my $pos;
		if(ref($file_ref) eq 'SCALAR'){
			# got a file name
			if (!open(dumpFD,$$file_ref)){
				defined $SAPDB::Install::Values::log && 
						$SAPDB::Install::Values::log->SetMsg("MSG: DataDumper::readDump(): cannot read dump: cannot open file \"$$file_ref\"\n");
				return undef;
			}	
			while(<dumpFD>){
				$dump_string.=$_;
			}	
			close(dumpFD);
		}
		elsif(ref($file_ref) eq 'GLOB'){
			# got an opened	 file descriptor
			defined fileno($file_ref) or print STDERR "readDump(): no valid file handle\n" and return 0;
			seek($file_ref,0,0) or print STDERR "readDump(): cannot seek to position 0: $!\n" and return 0;
			while(<$file_ref>){
				$dump_string .= $_;
			}

		}
		else{
			print STDERR ("readDump(): param error - no filename or file handle\n");
			return 0;
		}

        # truncate trailing zeros and other waste
        $pos = truncateString ($dump_string);

		return getElement (\$dump_string), $pos;
}

sub AUTOLOAD {
	die "cannot load symbol ".$AUTOLOAD."\n"
		unless ($AUTOLOAD =~ /bootstrap$/);

	require XSLoader;
	XSLoader::load (__PACKAGE__);
}


1;