package SAPDB::Install::LoadWx;
use strict;
use warnings;

use File::Spec;
use SAPDB::Install::Resources qw(getArchiveName);

if ($SAPDB::Install::Config{'RuntimeDir'}){
    # make sure that shared object is found
    push @INC, $SAPDB::Install::Config{'RuntimeDir'};
}

if($^O =~ /linux/i and defined $SAPDB::Install::Config{'UPUser'}){
    my @pwent = getpwnam($SAPDB::Install::Config{'UPUser'});
    my $homedir = $pwent[7];
    if(-d $homedir){
        my $qtrcdir = "$homedir/.qt";
        if(-d $qtrcdir){
            $ENV{'QT_HOME_DIR'} = $qtrcdir;
        }
    }
}

my $rc;
unless($SAPDB::Install::Config{'NO_SPLASH'}){
    eval{
        $rc = require SDB::Wx::Splash;
    }; die ("cannot load splash screen properly: $@") if $@;

    unless(defined $rc){
        die("cannot load splash screen properly: module returned false\n");
    }

    eval{
        my $resources_archive;
        if (defined $SAPDB::Install::Config{'RuntimeDir'}){
            $resources_archive = File::Spec->catfile($SAPDB::Install::Config{'RuntimeDir'}, getArchiveName());
        }
        if (!(defined $resources_archive && -f $resources_archive) && $ENV{HDBINST_RESOURCES_TGZ}){
            $resources_archive = $ENV{HDBINST_RESOURCES_TGZ};
        }
        my $filename = 'splash/InstallationManager.png';
        SDB::Wx::Splash->new ($resources_archive, $filename, 10000);
    }; die ("cannot show splash screen: $@") if $@;
}
else {
    eval{
        $rc = require Wx;
    }; die ("cannot load wxWidgets properly: $@") if $@;

    unless(defined $rc){
        die("cannot load wxWidgets properly: module returned false\n");
    }
}

our $is_gtk1 = $^O =~ /aix|hpux/;
 
sub Wx::wxGTK1 () {$is_gtk1}

1;
