#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#

package SAPDB::Install::MachInfo;

require Exporter;
our @ISA = qw (Exporter);

bootstrap SAPDB::Install::MachInfo;

our @EXPORT = qw (
		GetMachInfo 
		getPhysicalMemoryTotal
		getPhysicalMemoryAvailable
		getNumOfCPU
		getUnit
		normalizeToPages
		getPhysicalMemoryAvailable8KPages
		getPhysicalMemoryTotal8KPages
);

sub AUTOLOAD {
	die "cannot load symbol ".$AUTOLOAD."\n"
		unless ($AUTOLOAD =~ /bootstrap$/);

	require XSLoader;
	XSLoader::load (__PACKAGE__);
}

my %units = ( 1 => "BYTE" ,1024  => "KB",    1024*1024  =>  "MB", 1024*1024*1024  =>  "GB" );

sub getUnit{
  return $units{$_[0]};
}
sub getPhysicalMemoryTotal{
  my $ref = GetMachInfo ();
  my $ret = $ref->{"PhysicalMemoryTotal"};
  my ($val,$unit)  = @$ret;
  return ($val, getUnit($unit));
}
sub getPhysicalMemoryAvailable{
  my $ref = GetMachInfo ();
  my $ret = $ref->{"PhysicalMemoryAvailable"};
  my ($val,$unit)  = @$ret;
  return ($val, getUnit($unit));
}

sub getPhysicalMemoryTotal8KPages{
  my $ref = GetMachInfo ();
  my $ret = $ref->{"PhysicalMemoryTotal"};
  return normalizeToPages($ret);
}
sub getPhysicalMemoryAvailable8KPages{
  my $ref = GetMachInfo ();
  my $ret = $ref->{"PhysicalMemoryAvailable"};
  return normalizeToPages($ret);
}

sub normalizeToPages{
  my ($arg) = @_; 
  my ($val,$unit)  = @$arg;
  $unit = getUnit($unit);
  if("BYTE" eq $unit){
    $val = $val / (1024 * 8);
  }
  elsif("KB" eq $unit){
    $val = $val /  8;
  }
  elsif("MB" eq $unit){
    $val = $val  * (1024/8) ;
  }
  elsif("GB" eq $unit){
    $val = $val  * (1024/8) * 1024 ;
  }
  return ($val, "8K-PAGES");
}

sub getNumOfCPU{
  my $ref = GetMachInfo ();
  return $ref->{"NumOfCPU"};
}

1;
__END__

# Local Variables: ***
# perl-dbg-flags:"-w      -I../../../../../wrk/script -I../../sdbrun  " ***
# sdbinst-defines: "-define SCRIPTING=YES" ***
# sdbinst-testfile: "MachInfoTest.pl" ***
# sdbinst-script-directory:  "sys/wrk/script/SAPDB/Install" ***
# End: ***

