#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 


package SAPDB::Install::System::Win32::SecurityInfo;
bootstrap SAPDB::Install::System::Win32::SecurityInfo;

require Exporter;

our @ISA = qw (Exporter);

our @SDB_CONSTANTS = qw(SDB_OBJECTTYPE_DIRECTORY SDB_OBJECTTYPE_FILE);

our @GENERIC_CONSTANTS = qw(DELETE READ_CONTROL
				  WRITE_DAC WRITE_OWNER SYNCHRONIZE GENERIC_ALL
				  GENERIC_EXECUTE GENERIC_WRITE GENERIC_READ
				  MAXIMUM_ALLOWED ACCESS_SYSTEM_SECURITY 
				  STANDARD_RIGHTS_READ STANDARD_RIGHTS_WRITE);

our @FILE_CONSTANTS = qw (FILE_ALL_ACCESS FILE_APPEND_DATA SYNCHRONIZE
						  FILE_EXECUTE FILE_READ_DATA FILE_READ_EA
						  FILE_READ_ATTRIBUTES DELETE
						  FILE_WRITE_ATTRIBUTES FILE_WRITE_DATA
						  FILE_WRITE_EA WRITE_DAC WRITE_OWNER
						  STANDARD_RIGHTS_READ
						  GENERIC_EXECUTE GENERIC_WRITE GENERIC_READ);

our @DIR_CONSTANTS = qw(FILE_ALL_ACCESS FILE_ADD_FILE SYNCHRONIZE
						FILE_ADD_SUBDIRECTORY FILE_CREATE_PIPE_INSTANCE
						FILE_DELETE_CHILD FILE_LIST_DIRECTORY DELETE
						FILE_READ_ATTRIBUTES FILE_READ_EA WRITE_DAC WRITE_OWNER
						FILE_TRAVERSE FILE_WRITE_ATTRIBUTES FILE_WRITE_EA
						STANDARD_RIGHTS_READ STANDARD_RIGHTS_WRITE
						GENERIC_EXECUTE GENERIC_WRITE GENERIC_READ);
						
our @INHERITANCE_CONSTANTS = qw(CONTAINER_INHERIT_ACE INHERIT_ONLY_ACE
								NO_PROPAGATE_INHERIT_ACE OBJECT_INHERIT_ACE
								SUB_CONTAINERS_AND_OBJECTS_INHERIT
								SUB_CONTAINERS_ONLY_INHERIT SUB_OBJECTS_ONLY_INHERIT
								NO_INHERITANCE);
								
our @ACCESSMODE_CONSTANTS = qw (NOT_USED_ACCESS GRANT_ACCESS
								SET_ACCESS DENY_ACCESS
								REVOKE_ACCESS SET_AUDIT_SUCCESS
								SET_AUDIT_FAILURE);																				  
				  

our @EXPORT = qw (GetRightsString);

push @EXPORT,	@SDB_CONSTANTS,
				@GENERIC_CONSTANTS,
				@FILE_CONSTANTS,
				@DIR_CONSTANTS,
				@INHERITANCE_CONSTANTS,
				@ACCESSMODE_CONSTANTS;


sub GetRightsString{
	my ($mask,$type) = @_;
	
	my $package = __PACKAGE__;
	
	if (ref ($mask) =~ /$package/){
	
		#
		# called in obj context
		#
		
		$mask = $type;
		$type = $_[0]->GetObjectType;
	}
	
	
	my $result = '';
	my @rights;
	
	if (not defined $type){
		@rights = @GENERIC_CONSTANTS;
	}
	elsif ($type == SDB_OBJECTTYPE_FILE()){
		@rights = @FILE_CONSTANTS;	
	}
	elsif ($type == SDB_OBJECTTYPE_DIRECTORY()){
		@rights = @DIR_CONSTANTS;
	}
	else{
		@rights = @GENERIC_CONSTANTS;
	}	
	
	foreach my $right (@rights){	
 		if (($mask & &{$right}) == &{$right}){
			$result .= $right.' '; 
		}
	}
	return $result;
}

sub AUTOLOAD {
	die "cannot load symbol ".$AUTOLOAD."\n"
		unless ($AUTOLOAD =~ /bootstrap$/);

	require XSLoader;
	XSLoader::load (__PACKAGE__);
}


1;