#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Base class of a Wizard::Dialog
#

package SAPDB::Install::Wizard::Dialog::Base;

use Wx qw ( wxEXPAND wxCENTRE wxICON_ERROR wxOK
			wxICON_INFORMATION wxTAB_TRAVERSAL);

use SDB::Install::Gui::Design qw (SDBBGCOLOUR_WizardDialog);

our @ISA = qw (Wx::Panel);

sub new{
	my ($class,@args) = @_;
	$args[1] = -1;
	$args[2] = [0,0];
	$args[3] = [0,0];

	my ($self ) = $class->SUPER::new(@args);
	
	$self->Show (0);
	
	$self->{name} = undef;
	$self->{id} = undef;
	$self->{step} = undef;
	$self->{substep} = undef;
	$self->{skip} = 0;
	
		
	$self->SetWindowStyleFlag($self->GetWindowStyleFlag | wxTAB_TRAVERSAL);
	$self->SetBackgroundColour (SDBBGCOLOUR_WizardDialog);
	return $self;
}


sub SetPrevious ($$) {$_[0]->{prev} = $_[1]}

sub SetNext ($$) {$_[0]->{next} = $_[1]}

sub SetSkip ($$) {$_[0]->{skip} = $_[1]}

sub SetStep ($$) {$_[0]->{step} = $_[1]}

sub SetSubStep ($$) {$_[0]->{substep} = $_[1]}

sub DirectNavigationAllowed ($) {1}

sub GetPrevious ($) {$_[0]->{prev}}

sub GetNext ($) {$_[0]->{next}}

sub GetName ($) {$_[0]->{name}}

sub GetID ($) {$_[0]->{id}}

sub GetStep ($) {$_[0]->{step}}

sub GetSubStep ($) {$_[0]->{substep}}

sub GetSkip ($) {$_[0]->{skip}}


sub Reset ($){
	delete $_[0]->{initialized};
}


sub CanBackward ($){
		my $dlg = $_[0];
	
		while (defined $dlg->{prev}){
			$dlg = $dlg->{prev};
			if ($dlg->{skip}){
				next;
			}
			if (!defined $dlg->{name}){
				next;
			}
			return 1;
		}				
		return 0;		
}


sub GetWizard{
	my ($self) = @_;
	return $self->GetParent;
}

sub SetError{
	my ($self,$title,$msg) = @_;
	my $msgbox = Wx::MessageDialog->new($self,$msg,
				$title, wxICON_ERROR | wxCENTRE | wxOK);
	
	$msgbox->ShowModal();
	$msgbox->Destroy;
	return 1;
}

sub SetMsg{
	my ($self,$title,$msg) = @_;
	my $msgbox = Wx::MessageDialog->new($self,$msg,
				$title, wxICON_INFORMATION | wxCENTRE | wxOK);
	
	$msgbox->ShowModal();
	$msgbox->Destroy;
	return 1;	
}



sub init{
	my ($self,$config) = @_;
	$self->Enable(1);
	$self->Show(1);
	return {};
}

sub Process{
	my ($self,$config) = @_;
	return {};
}

sub Destroy{
	my ($self) = @_;
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
	if defined $SAPDB::Install::DEBUG::DESTRUCT &&
			$SAPDB::Install::DEBUG::DESTRUCT;
}


sub _getUserConfirmationMessagePattern {
	my ($self, $parameter, $parameterId, $logvalue) = @_;
	my $parameterInfo = $self->_getParameterInfoForMessageString( $parameter );
	return sprintf("Parameter %s %s is set by user. User confirmed the default value = '%s'",
		$parameterInfo->{parameterString}, $parameterInfo->{parameterId}, $logvalue);
}

sub _getIsSetByUserMessagePattern {
	my ($self, $parameter, $parameterId, $logvalue) = @_;
	my $parameterInfo = $self->_getParameterInfoForMessageString( $parameter );
	return sprintf("Parameter %s %s is set by user, value = '%s'",
		$parameterInfo->{parameterString}, $parameterInfo->{parameterId}, $logvalue);
}

sub _getSetByUserMessagePattern {
	my ($self, $parameter) = @_;
	return "Parameter \"$parameter->{str}\" is set by user, value is empty" if (defined $parameter->{str});
	return "Parameter \"$parameter->{opt}\" is set by user, value is empty";
}

sub _getParameterInfoForMessageString {
	my ($self, $parameter, $parameterId) = @_;
	my $parameterString = "";
	if (defined $parameter->{opt}) {
		$parameterString = "\'$parameter->{opt}\'";
	} elsif ( defined $parameter->{str} ) {
		$parameterString = "\'$parameter->{str}\'";
	}

	my $parameterStringId = defined $parameterId ? "($parameterId)" : "";
	return { 
		'parameterString' => $parameterString,
		'parameterId' => $parameterStringId
	};
} 


1;
