package SDB::Common::ProcessUtils;

use strict;
use parent 'Exporter';
use SDB::Install::MsgLst;
use SAPDB::Install::ProcState;

our @EXPORT = qw(terminateProcessAfterTimeout getProcessId terminateProcess);

sub terminateProcessAfterTimeout {
    my ($sidadmUid, $procName, $timeout, $msglst) = @_;
    my $pid;
    my $endTime = time() + $timeout;

    do {
        $pid = getProcessId($sidadmUid, $procName);
        if(time() >= $endTime){
            return terminateProcess($pid, $msglst);
        }
        sleep(1);
    } while(defined $pid);

    return 1;
}

sub terminateProcess {
    my ($pid, $msglst) = @_;
    $msglst //= SDB::Install::MsgLst->new();
    my $rc = 1;

    my $ps = SAPDB::Install::ProcState->new();
    my $cmd = $ps->GetArgs($pid);
    if($ps->Terminate($pid, $ps->GetUid($pid), $cmd) == 0){
        $msglst->addMessage("Process '$cmd' (pid = $pid) is killed'");
    } else{
        $msglst->addError("Killing process '$cmd' (pid = $pid) failed: $!");
        $rc = 0;
    }
    return $rc;
}

sub getProcessId {
    my ($uid, $procName) = @_;
    my $ps = SAPDB::Install::ProcState->new();

    foreach my $proc (@{$ps->{procs}}) {
        next if($proc->{uid} != $uid);

        my $processCmd = $ps->GetCmd($proc->{pid});
        if ($processCmd =~ /$procName/) {
            return $proc->{pid};
        }
    }
    return undef;
}

1;
