package SDB::Install::App::Console::HdbContainer;

use Getopt::Long;

use SDB::Install::Configuration::Container::HdbInitPersistenceConfig;
use SDB::Install::Configuration::Container::HdbInitialStartConfig;
use SDB::Install::Configuration::Container::HdbInitSSFSConfig;
use SDB::Install::Configuration::Container::HdbUpdateContainerConfig;
use SDB::Install::Configuration::Container::HdbCheckContainerConfig;
use SDB::Install::Configuration::Container::HdbActivatePluginsConfig;
use SDB::Install::Configuration::Container::HdbCheckUpdateConfig;
use SDB::Install::SAPSystemContainerHelper::InitPersistenceContainerHelper;
use SDB::Install::SAPSystemContainerHelper::InitialStartContainerHelper;
use SDB::Install::SAPSystemContainerHelper::InitSSFSContainerHelper;
use SDB::Install::SAPSystemContainerHelper::UpdateContainerHelper;
use SDB::Install::SAPSystemContainerHelper::CheckSystemRequirementsContainerHelper;
use SDB::Install::SAPSystemContainerHelper::ActivatePluginsContainerHelper;
use SDB::Install::SAPSystemContainerHelper::CheckUpdateContainerHelper;

use SDB::Install::Globals qw ($gProductNameInstaller $gTmpDir);
use SDB::Install::Log;

use base SDB::Install::App::Console;

use strict;

sub new {
    my $self = shift->SUPER::new();
    return $self;
}

sub InitCmdLineArgs{
    my ($self, $args) = @_;

    my $action;
    GetOptions ('action=s' => \$action);

    if(!$self->_InitCmdLineArgs_aux($action)) {
    	return undef;
    }

    return $self->SUPER::InitCmdLineArgs ($args);
}

sub _InitCmdLineArgs_aux {
    my ($self, $action) = @_;
    if  ($action eq "init_persistence") {
        $self->{'instconfig'} = new SDB::Install::Configuration::Container::HdbInitPersistenceConfig($self->{options});
        $self->{'containerHelper'} = new SDB::Install::SAPSystemContainerHelper::InitPersistenceContainerHelper();
        $self->{'progressMessage'} = "Initializing persistence...";
        $self->{'errorMessage'} = "Cannot initialize persistence.";
        return 1;
    }
    elsif  ($action eq "initial_start") {
        $self->{'instconfig'} = new SDB::Install::Configuration::Container::HdbInitialStartConfig($self->{options});
        $self->{'containerHelper'} = new SDB::Install::SAPSystemContainerHelper::InitialStartContainerHelper();
        $self->{'progressMessage'} = "Initial start of the container...";
        $self->{'errorMessage'} = "Cannot start container.";
        return 1;
    }
    elsif  ($action eq "init_ssfs") {
        $self->{'instconfig'} = new SDB::Install::Configuration::Container::HdbInitSSFSConfig($self->{options});
        $self->{'containerHelper'} = new SDB::Install::SAPSystemContainerHelper::InitSSFSContainerHelper();
        $self->{'progressMessage'} = "Initializing SSFS...";
        $self->{'errorMessage'} = "Cannot initialize SSFS.";
        return 1;
    }
    elsif  ($action eq "update_container") {
        $self->{'instconfig'} = new SDB::Install::Configuration::Container::HdbUpdateContainerConfig($self->{options});
        $self->{'containerHelper'} = new SDB::Install::SAPSystemContainerHelper::UpdateContainerHelper();
        $self->{'progressMessage'} = "Updating container...";
        $self->{'errorMessage'} = "Cannot update container.";
        return 1;
    }
    elsif  ($action eq "check_container") {
        $self->{'instconfig'} = new SDB::Install::Configuration::Container::HdbCheckContainerConfig($self->{options});
        $self->{'containerHelper'} = new SDB::Install::SAPSystemContainerHelper::CheckSystemRequirementsContainerHelper();
        $self->{'progressMessage'} = "Checking container...";
        $self->{'errorMessage'} = "Cannot check container.";
        return 1;
    }
    elsif  ($action eq "activate_plugins") {
        $self->{'instconfig'} = new SDB::Install::Configuration::Container::HdbActivatePluginsConfig($self->{options});
        $self->{'containerHelper'} = new SDB::Install::SAPSystemContainerHelper::ActivatePluginsContainerHelper();
        $self->{'progressMessage'} = "Activating plugins...";
        $self->{'errorMessage'} = "Cannot activate plugins.";
        return 1;
    }
    elsif  ($action eq "check_update") {
        $self->{'instconfig'} = new SDB::Install::Configuration::Container::HdbCheckUpdateConfig($self->{options});
        $self->{'containerHelper'} = new SDB::Install::SAPSystemContainerHelper::CheckUpdateContainerHelper();
        $self->{'progressMessage'} = "Checking update path...";
        $self->{'errorMessage'} = "Cannot check update path.";
        return 1;
    }
    else {
        return undef;
    }
}

sub init {
    my ($self) = @_;

    my $msglst = $self->getMsgLst ();
    my $caption = "$gProductNameInstaller - HdbContainer " .$self->GetInstaller->{version};
    $msglst->addProgressMessage ("\n\n".$caption . "\n" . ('*' x length ($caption)) . "\n\n");

    my $rc = $self->getInstconfig()->CheckParams(1);
    if (!$rc) {
        $self->setErrorMessage ('Configuration error:', $self->getInstconfig()->getErrMsgLst());
        return undef;
    }

    my $action = $self->getInstconfig()->getValue("Action");
    my $logFilename = "HdbContainer_$action"."_LOGDATETIME.log";
    $self->{log}->addLogFileLocation(LOG_FORMAT_PLAIN,   $gTmpDir, 1, $logFilename, LOG_INDICATE_LOCATION_ON_STDOUT,
                                     undef, undef, undef, undef, $ENV{HDBLCM_LOGDIR_COPY});

    $msglst->addProgressMessage($self->{'progressMessage'});
    $self->{'containerHelper'}->setMsgLstContext([$msglst]);

    return $self->_performAction();
}

sub _performAction {
    my ($self) = @_;
    
    my $sapSys = $self->getInstconfig()->getSAPSystem();
    my $sysinfo = $self->GetSysInfo();
    my $rc = $self->{'containerHelper'}->performContainerAction($self->getInstconfig(), $sapSys, $sysinfo, $self);
    if(!$rc) {
        $self->setErrorMessage($self->{'errorMessage'}, $self->{'containerHelper'}->getErrMsgLst());
        return undef;
    }
    return 1;
}

sub main{
    my $app = new __PACKAGE__;

    my $rc;
    eval{

        if (!defined $app->InitCmdLineArgs (\@_)){
           return undef;
        }

        if (defined $app->{return}){
            LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
            return $app->{return};
        }

        $rc = $app->init ();

    };

    if (defined $app->{return}){
        LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
        return $app->{return};
    }

    $rc = $app->handleReturnCodes($@, $rc);

    $app->CleanUp ();

    undef $app;

    return defined $rc ? 0 : 1;
}

1;
