#!/usr/bin/perl
#
# Desc: Executes remote tools via saphostctrl.

package SDB::Install::App::Console::HdbHostctrl;

use base SDB::Install::App::Console;

use SDB::Install::Configuration::HdbHostctrl;
use SDB::Install::Globals qw ($gProductNameInstaller);
use SDB::Install::Tools qw (askConfirmation);

use strict;

our $programVers = '0014';


#-------------------------------------------------------------------------------
# Constructor
sub new {
    my $self = shift->SUPER::new ();
    return $self;
}


#-------------------------------------------------------------------------------
sub getActionDone {
	return undef; # suppress end message
}


#-------------------------------------------------------------------------------
# Returns a reference to an array containing help/info options of the program.

sub GetHelpSwitches {

    return ['--help', '--version'];
}


#-------------------------------------------------------------------------------
# Returns the name of this program

sub getProgramName {
    return 'hdbhostctrl';
}


#-------------------------------------------------------------------------------
# Returns a reference to an array of arrays
# containg the description of program options without common batch/help options.

sub GetUsage{

    return $_[0]->getInstconfig()->GetUsageFromParams();
}


#-------------------------------------------------------------------------------
# Initializes this application
# Without parameters
# Returns int 1

sub InitApp{
    my ($self) = @_;
    $self->SUPER::InitApp();
    return 1;
}


#-------------------------------------------------------------------------------
sub init{
    my ($self) = @_;

    my $instconfig     = $self->getInstconfig();
    my $msglst         = $self->getMsgLst ();
    my $strProgramName = $self->getProgramName();
    my $strHeadline    = "$gProductNameInstaller - $strProgramName  "
                                               . $self->GetInstaller->{version};
    $instconfig->SetProgressHandler ($msglst->getProgressHandler());
    $msglst->addProgressMessage("\n\n" . $strHeadline . "\n"
                                . ('*' x length($strHeadline)) . "\n");
    $self->addStartDateMsg($msglst, $strProgramName . "  $programVers");

    $msglst->appendMsgLst($instconfig->getMsgLst());
    $instconfig->resetMsgLstContext();

    my $msg = $msglst->addMessage ("Checking parameters...");
    my $rc = $instconfig->CheckParams ($self->{batch_mode});

    my $cfgDumpRc = $self->handleOptionDumpConfigFileTemplate();
    if (!defined $cfgDumpRc){
        $self->{return} = 1;
        return undef;
    }
    if ($cfgDumpRc){
        $self->{return} = 0;
        return 1;
    }

    if($self->{batch_mode}){
        if (!$rc){
            if (defined $rc){
                $self->setErrorMessage ("Running in batch mode", $instconfig->getErrMsgLst ());
            }
            else{
                $self->setErrorMessage ('Invalid parameter (batch mode):', $instconfig->getErrMsgLst ());
            }
            $msg->getSubMsgLst ()->appendMsgLst ($instconfig->getMsgLst ());
            return undef;
        }
    }
    else{
        if (!$rc && $instconfig->ErrorState ()){
            $self->ShowErrorMsg ('Invalid parameter:',$instconfig->getErrMsgLst ());
        }
        if (!defined $self->ConfigureInteractive ($instconfig)){
            return undef;
        }
    }

    $msg->getSubMsgLst ()->appendMsgLst ($instconfig->getMsgLst ());
    $instconfig->resetMsgLstContext();

    if (!$self->defineLog($strProgramName,
                          $strProgramName,
                          0, # not check only
                          $instconfig->getSID())) {
        return undef;
    }

    $instconfig->dumpConfigFile($strProgramName);
    $instconfig->displayParameterSummary();
    $msg->getSubMsgLst()->appendMsgLst($instconfig->getMsgLst());
    $instconfig->resetMsgLstContext();

    if (!$self->{batch_mode} && !$self->{options}->{noprompt}
                                                        && !askConfirmation()) {
        $msglst->addProgressMessage('Cancelled');
        $self->{return} = 0;
        return 1;
    }

    $msg = $msglst->addMessage ("Executing SAPHostControl...");

    my $sapSys = $instconfig->getSAPSystem();
    if (defined $sapSys) {
        $self->addLogToTraceDir($sapSys, $strProgramName);
    }

    $rc = $instconfig->executeRemoteOperations();

    if (!$rc) {
        $self->appendErrorMessage(undef, $instconfig->getErrMsgLst());
    }

    $msg->getSubMsgLst()->appendMsgLst($instconfig->getMsgLst());
    $msg->endMessage();
    return $rc;
}


#-------------------------------------------------------------------------------
# Initializes the arguments of the command line
#
# Parameters string-array arguments
#
# Returns a reference to a string array containing the arguments
#         or undef in case of an error

sub InitCmdLineArgs{
    my ($self,$args) = @_;
    $self->{instconfig} =
            new SDB::Install::Configuration::HdbHostctrl ($self->{options});

    return $self->SUPER::InitCmdLineArgs ($args);
}



#===============================================================================
#   M A I N

sub main{
    my $app = new __PACKAGE__;
    return $app->mainFunction(\@_);
}


sub shouldWarnIfCalledStandalone{
    return 0;
}

1;
