#!/usr/bin/perl
#
# Desc: Adds additional host roles at a remote host triggered by hdbmodify.
#       The main method is called by SDB::Install::RemoteHosts::executeParallel


package SDB::Install::App::Console::HdbModifyHostRoles;

use base SDB::Install::App::Console::HdbModify;
use SAPDB::Install::Hostname qw(hostname);

use strict;


#-------------------------------------------------------------------------------
# Constructor
sub new {

    my $self = shift->SUPER::new ();

    return $self;
}


#-------------------------------------------------------------------------------
# Additional initialization sets isSlave.
#
# Return int retcode

sub additionalInit {
    my ($self) = @_;
    $self->{instconfig}->{isSlave} = 1;
    return $self->SUPER::additionalInit();
}


#-------------------------------------------------------------------------------
# Returns the name of this program

sub getProgramName {
    return 'hdbmodify_addRoles_' . lc(hostname());
}


#-------------------------------------------------------------------------------
# Initializes the program and performs several checks.
#
# Returns undef in case of an error

sub init {

    my ($self) = @_;

    if(!$self->{batch_mode}){
        $self->setErrorMessage ($self->getProgramName()
                                . ' is not supported in interactive mode');
        return undef;
    }

    return $self->SUPER::init();
}


#===============================================================================
#   M A I N

sub main{
    my $app = new __PACKAGE__;
    return $app->mainFunction(\@_);
}


sub shouldWarnIfCalledStandalone{
    return 0;
}

1;
