#!/usr/bin/perl
#
# Desc: Registers or unregisters a SAP HANA instance at a remote host.
#       The main method is called by SDB::Install::RemoteHosts::executeParallel
#
# This tool checks the configuration and detects:
#   - missing users
#   - missing groups
#   - missing or incomplete sapinit files
#   - missing sapservices
#
# Like hdbrename, the tool repairs the detected configuration problems.


package SDB::Install::App::Console::HdbRegHost;

use base SDB::Install::App::Console::HdbReg;
use SAPDB::Install::Hostname qw(hostname);

use strict;


#-------------------------------------------------------------------------------
# Constructor
sub new {

    my $self = shift->SUPER::new ();

    return $self;
}


#-------------------------------------------------------------------------------
# Additional initialization sets isSlave.
#
# Return int retcode

sub additionalInit {
    my ($self) = @_;
    $self->{instconfig}->{isSlave} = 1;
    return $self->SUPER::additionalInit();
}


#-------------------------------------------------------------------------------
# Returns the name of this program

sub getProgramName {
    return 'hdbreg_' . lc(hostname());
}


#-------------------------------------------------------------------------------
# Initializes the program and performs several checks.
# Without parameters
# Returns undef in case of an error

sub init {

    my ($self) = @_;

    if(!$self->{batch_mode}){
        $self->setErrorMessage ($self->getProgramName()
                                . ' is not supported in interactive mode');
        return undef;
    }

    return $self->SUPER::init();
}


#-------------------------------------------------------------------------------
# Returns true if the SAP HANA system should be stopped before
# registering this instance.

sub isStopSystem {
    return 0;
}


#-------------------------------------------------------------------------------
# Displays additional information

sub showAdditionalInfo {
    return 1;
}

sub shouldWarnIfCalledStandalone{
    return 0;
}


#===============================================================================
#   M A I N

sub main{
    my $app = new __PACKAGE__;
    return $app->mainFunction(\@_);
}


1;
