#!/usr/bin/perl
#
# Desc: Unregisters a SAP HANA instance.
#       This class is provided for hdblcm that calls 'mainFunction'.


package SDB::Install::App::Console::LCMUnregister;

use SDB::Install::Configuration::HdbReg;
use SDB::Install::Globals qw ($gProductName);

use base SDB::Install::App::Console::HdbReg;

use strict;


#-------------------------------------------------------------------------------
# Constructor
sub new {

    my $self = shift->SUPER::new ();

    return $self;
}

#-------------------------------------------------------------------------------
# Returns a reference to an array containing help/info options of the program.

sub GetHelpSwitches {

    return ['--help [--action=unregister_instance|unregister_system]',
            '--list_systems',
            '--version'];
}

#---------------------------------------------------------------------------------------------------------------
# Returns a reference to an array containing hdbupd options
# without help/info options.

sub GetSwitches{

    return [@{$_[0]->SUPER::GetSwitches()},
            '--action=unregister_instance|unregister_system'];
}

#-------------------------------------------------------------------------------
# Returns a reference to an array of arrays
# containg the description of program options without common batch/help options.

sub GetUsage{

    return [@{$_[0]->SUPER::GetUsage()},
            ['--action=unregister_instance|unregister_system', undef,
             "Unregisters $gProductName instance (local host only) or system (all hosts)"]
           ];
}


#-------------------------------------------------------------------------------
# Additional initialization hides parameters that are not used for unregister.
#
# Return int retcode

sub additionalInit {

    my ($self) = @_;

    $self->{instconfig}->hideRegisterAndStartStopParams();

    # hdblcm uses '--action=unregister' and sets '--unregister' for HdbReg
    $self->{instconfig}->{params}->{Unregister}->{hidden} = 1;

    return 1;
}


sub shouldWarnIfCalledStandalone{
    return 0;
}

1;
