package SDB::Install::App::Console::LSS::LSSConfigExecutor;

use strict;
use SDB::Install::LSS::Tools::LSSConfig;
use SDB::Install::Manifest;
use SDB::Common::BuiltIn;
use SDB::Common::Utils qw(getSidcryptName);
use SDB::Install::User;
use SDB::Install::App::Console;
use SDB::Install::OutputHandler::LssOutputHandler;
use Getopt::Long;

sub main {
    my ($lssCfg, $manifest);
    my ($sid, $manifest_dir, $register, $unregister, $trust, $trust_level, $signature_path);
    my $rc = 1;

    GetOptions ('sid=s' => \$sid,
                'manifest_dir=s' => \$manifest_dir,
                'register' => \$register,
                'unregister' => \$unregister,
                'trust' => \$trust,
                'trust_level' => \$trust_level,
                'signature_path=s' => \$signature_path
    );
    my $username = getSidcryptName($sid);
    my $user = new SDB::Install::User($username);
    my $sidcryptUid = $user->exists() ? $user->id() : undef;

    $lssCfg = SDB::Install::LSS::Tools::LSSConfig->new($sid, $sidcryptUid, $user->gid());
    $manifest = SDB::Install::Manifest->new(File::Spec->catfile($manifest_dir, 'manifest'));

    my $console = SDB::Install::App::Console->new();
    my $outputHandler = SDB::Install::OutputHandler::LssOutputHandler->new($console);
    $lssCfg->setOutputHandler($outputHandler);

    if($register){
        $rc = !$lssCfg->importComponentHashes($manifest, $signature_path);
    } elsif($unregister){
        $rc = !$lssCfg->deleteComponent($manifest);
    } elsif($trust){
        $rc = !$lssCfg->trustComponent($manifest, $trust_level);
    } else{
        SDB::Common::BuiltIn->get_instance()->print("Action is not defined (use --register, --unregister or --trust).\n");
    }

    return $rc;
}

1;