

package SDB::Install::App::Gui;

use Getopt::Long;
use SAPDB::Install::LoadWx;
use SDB::Install::App::AnyApp;
use Wx qw (wxICON_ERROR wxCENTRE wxOK wxICON_INFORMATION);
use SDB::Install::Gui::Window::Dialog::Usage;

our @ISA = qw (Wx::App SDB::Install::App::AnyApp);


sub new{
	my $self = shift->SUPER::new (); # Wx::App ctor
	# init SDB::Install::App properties
	$self->{msglst} = new SDB::Install::MsgLst ();
	$self->InitApp ();
	return $self;
}


sub CloseSplashScreen{
    my ($self,$hideFirst) = @_;
    if (defined $SDB::Wx::Splash::Window) {
        if ($hideFirst){
            $SDB::Wx::Splash::Window->Show (0);
        }
        $SDB::Wx::Splash::Window->Close ();
        Wx::Yield();
        undef $SDB::Wx::Splash::Window;
    }
    return 1;
}


#
# override this method to get a custom entry point
#

sub getFrameWindow{
    my ($self) = @_;
    return (new Wx::Frame (undef,-1, 'Gui App',[-1,-1],[-1,-1]));
}

#
# a Wx::App class has to implement OnInit() method
#
sub OnInit{
    my ($self) = @_;
    $self->SetTopWindow ($self->getFrameWindow ());
    return 1;
}

sub SetProgress () {
	Wx::Yield ();
}

sub ParseConfigCmdLineArgs {
    my $self = shift();
    $self->{return} = undef;

    return $self->SUPER::ParseConfigCmdLineArgs(@_);
}

sub ShowErrorMsg{
    my ($self,$text,$list) = @_;
    if ($self->{batch_mode}){
        return shift->SUPER::ShowErrorMsg (@_);
    }
    my $errtext = !defined $list  ?  $text :
                    !$list->isEmpty () ? ${$list->getMsgLstString ()} : 'Unknown Error';

    my $msg = $self->setErrorMessage ($text,$list,4);
    require SDB::Install::Gui::Window::Dialog::MessageDialog;
    my $msgbox = new SDB::Install::Gui::Window::Dialog::MessageDialog($self->GetTopWindow() ,$errtext,
                defined $list ? $text : 'Error' , wxICON_ERROR | wxCENTRE | wxOK);
    $self->CloseSplashScreen (1);
    $msgbox->ShowModal();
    $msgbox->Destroy;
    return $msg;
}

sub ShowInfoMsg{
    my ($self,$text) = @_;
    if ($self->{batch_mode}){
        print STDOUT "$text\n";
        return 1;
    }
    require SDB::Install::Gui::Window::Dialog::MessageDialog;
    my $msgbox = new SDB::Install::Gui::Window::Dialog::MessageDialog($self->GetTopWindow() ,$text,
                'Information' , wxICON_INFORMATION | wxCENTRE | wxOK);
    $self->CloseSplashScreen (1);
    $msgbox->ShowModal();
    $msgbox->Destroy;
    return 1;
}


#-------------------------------------------------------------------------------
#  Opens a window and displays the error message and the help information.
#
# Parameters: string $text
#             string $windowTitle
#             flag   $wxIcon      # undef or e.g. wxICON_ERROR

sub WrongUsage{
    my ($self, $errlst) = @_;

    my $title = "Wrong usage!";
    $self->setErrorMessage ($title, $errlst);

    my $wrongUsageMsgLst = SDB::Install::MsgLst->new();
    $wrongUsageMsgLst->appendMsgLst($errlst);
    $wrongUsageMsgLst->addMessage("\n\n" . $self->getUsageString());

    $self->ShowErrorMsg($title, $wrongUsageMsgLst);
}


#-------------------------------------------------------------------------------
# Opens a window and displays the usage (help information) of the program.

sub PrintUsage{
    my ($self) = @_;
    $self->PrintText($self->getUsageString(), 'Usage');
}


#-------------------------------------------------------------------------------
# Opens a window and displays the specified text.
#
# Parameters: string $text
#             string $windowTitle
#             flag   $wxIcon      # undef or e.g. wxICON_ERROR

sub PrintText {

    my ($self, $text, $windowTitle, $wxIcon) = @_;

    my $icon   = (defined $wxIcon) ? $wxIcon : wxICON_INFORMATION;
    my $msgbox = new SDB::Install::Gui::Window::Dialog::Usage
                                        ($self->GetTopWindow(), -1, $text, $windowTitle, $icon);
    $self->CloseSplashScreen (1);
    $msgbox->setMinResizeBound();
    $msgbox->ShowModal();
    $msgbox->Destroy;
}


sub startMainLoop{
    my ($self) = @_;

    #
    # the frame is set in wxApp::OnInit () method
    #

    my $frame = $self->GetTopWindow ();
    if (defined $frame){
        $frame->StartWizard ();
        $frame->Show (1);
    }
    $self->CloseSplashScreen ();

    if (defined $frame){
        $self->MainLoop ();
    }
    return 1;
}



sub DESTROY{
	my ($self) = @_;
	$self->Destroy ();
	$self->SDB::Install::App::DESTROY();
}

sub shouldWarnIfCalledStandalone{
    return 0;
}

1;
