package SDB::Install::BaseLegacy;
use SDB::Install::Base;
use Exporter;
use strict;

our @ISA = qw (SDB::Install::Base Exporter);
our $caller_level = 2;

our @EXPORT = qw (AddMessage AddError AddProgressMessage AddSubMessage);

#
# helper function converts input parameter into MsgLst object
# 1. param: in, obj of type MsgLst or Base / hash refence
# 2. param: in, boolean, treat object in error context
#           (required for Base derived objects)
# returns:  MsgLst object

sub getMsgLstObjFromParam ($$){
    if (!defined $_[0] || !ref ($_[0])){
        return undef;
    }
    if (ref ($_[0]) eq 'HASH'){
        return bless ($_[0], 'SDB::Install::MsgLst');
    }
    if ($_[0]->isa ('SDB::Install::MsgLst')){
        return $_[0];
    }
    elsif ($_[0]->isa ('SDB::Install::Base')){
        if ($_[1]){
            return $_[0]->getErrMsgLst();
        }
        else{
            return $_[0]->getMsgLst();
        }
    }
    return undef;
}

sub ErrorState{
    return $_[0]->errorState ();
}

sub ResetError{
    return $_[0]->resetError ();
}

sub AddMessage{
    my ($self, $text, $sublst, $type, $level) = @_;
    if (!defined $self){
        return undef;
    }
    if (defined $sublst){
        $sublst = getMsgLstObjFromParam ($sublst,0);
    }
    my $msglst = getMsgLstObjFromParam ($self,0);
    return $msglst->addMessage ($text, $sublst, $type, defined $level ? $level : $caller_level);
}

sub GenMsg{
    my ($self, $type, $text, $level) = @_;
    my $msglst = getMsgLstObjFromParam ($self, 0);
    
    if (!defined $type || $type eq 'INFO'){
        return $msglst->addMessage ($text,undef, undef, defined $level ? $level : $caller_level);
    }
    elsif ($type eq 'ERR'){
        return $msglst->addError ($text,undef, defined $level ? $level : $caller_level);
    }
    else{
        return $msglst->addWarning ($text,undef, defined $level ? $level : $caller_level);
    }
}

sub AddWarning{
    my ($self, $text, $sublst, $level) = @_;
    if (defined $sublst){
        $sublst = getMsgLstObjFromParam ($sublst,0);
    }
    my $msglst = getMsgLstObjFromParam ($self,0);
    return $msglst->addWarning ($text, $sublst, defined $level ? $level : $caller_level);

}

sub AddMessages{
    my ($self,$textList,$type,$level) = @_;
    foreach my $line (@$textList) {
        AddMessage($self, $line, undef, $type, defined $level ? $level : ($caller_level + 1));
    }
}

sub AddProgressMessage{
    my ($self, $text, $sublst, $level) = @_;
    if (defined $sublst){
        $sublst = getMsgLstObjFromParam ($sublst,0);
    }
    my $msglst = getMsgLstObjFromParam ($self,0);
    return $msglst->addProgressMessage ($text, $sublst, defined $level ? $level : ($caller_level + 1));
}

sub PushError{
    my ($self, $text, $sublst, $level) = @_;
    if (!defined $level){
        $level = 4;
    }
    if (defined $sublst){
        $sublst = getMsgLstObjFromParam ($sublst,1);
    }
    if (ref ($self) eq 'HASH'){
        $self = bless ($self, 'SDB::Install::MsgLst');
    }
    return $self->appendErrorMessage ($text, $sublst, $level);
}

sub PushErrors{
    my ($self, $errors) = @_;
    foreach my $text (@$errors){
        $self->appendErrorMessage ($text, undef, 4);
    }
}

sub AddError{
    my ($self, $text, $sublst, $level) = @_;
    if (!defined $level){
        $level = 4;
    }
    if (defined $sublst){
        $sublst = getMsgLstObjFromParam ($sublst,1);
    }
    if (ref ($self) eq 'HASH'){
        $self = bless ($self, 'SDB::Install::MsgLst');
    }
    if ($self->isa ('SDB::Install::MsgLst')){
        return $self->addError ($text,$sublst,3);
    }
    return $self->setErrorMessage ($text, $sublst, $level);
}

sub GetErrorString{
    if (defined $_[0]->{errlst}){
        return ${shift->{errlst}->getMsgLstString(@_)};
    }
    return '';
}

sub GetProgressHandler{
    my ($self) = @_;
    if (!defined $self->{msglst}){
        if ($self->isa ('SDB::Install::ProgressHandler')){
            return $self;
        }
        return undef;
    }
    return $self->{msglst}->getProgressHandler ();
}

sub SetProgressHandler{
    my ($self, $progressHandler) = @_;
    if (!defined $self->{msglst}){
        $self->{msglst} = new SDB::Install::MsgLst ();
     }
    return $self->{msglst}->setProgressHandler ($progressHandler);
}

sub SetFormatInfo{
    if (defined $_[1] && $_[1]->isa ('SDB::Install::Msg')){
        return $_[1]->setEndTag (1, $_[3]);
    }
}

sub GetMsgListString{
    my ($self) = @_;
    if (defined $self->{msglst}){
        return $self->{msglst}->getMsgLstString($_[1], 0, 1);
    }
    return '';
}

sub AddSubMsgLst{
    my ($self, $msg, $msglst) = @_;
    $msglst = getMsgLstObjFromParam ($msglst,0);
    $msg->getSubMsgLst()->appendMsgLst ($msglst);
}

sub AddSubMessage{
    my ($self, $msg,$text,$sublst,$type, $level) = @_;
    if (ref ($text)){
        return $msg->getSubMsgLst()->appendMsg ($text);
    }
    if (!defined $level){
        $level = 3;
    }
    if (defined $sublst){
        $sublst = getMsgLstObjFromParam ($sublst,0);
    }
    $msg->getSubMsgLst()->addMessage ($text, $sublst,$type, $level);
}


1;

