package SDB::Install::ComponentVersion::APLComponentVersion;

use strict;
use parent 'SDB::Install::ComponentVersion';

# Introduced because of Bug 218793
#   - old style APL release: 1902.0, 1903.0, etc..
#   - new style APL release: 4.203, 4.204, etc...
#
# Upgrade from old style to new style should be possible


sub isNewerThan {
    my ($self, $otherVersion) = @_;
    my $release = $self->_getIntegerDetails()->[0];
    my $otherRelease = $otherVersion->_getIntegerDetails()->[0];

    if ($self->_isNewStyleRelease($release) && $otherRelease > 1000) {
        return 1;
    } elsif ($release > 1000 && $self->_isNewStyleRelease($otherRelease)) {
        return 0;
    }

    return $self->SUPER::isNewerThan($otherVersion);
}

sub _isNewStyleRelease {
    my ($self, $release) = @_;
    return $release < 1000 && $release >= 4;
}

1;
