package SDB::Install::Configuration::AutoInitFamilyServicesParamHandler;
use strict;
use warnings;

sub new {
    my ( $class, $paramId ) = @_;
    my $self = bless( {}, shift );
    $self->{_param} = $paramId;
    return $self;
}

sub onValueChange {
    my ( $self, $value, $configuration ) = @_;
    my $isAutoInitializeServicesRequired = $configuration->isAutoInitializeServicesRequired();
    $configuration->setSkip('AutoInitializeServices', !$isAutoInitializeServicesRequired);
    return 1 if (!$isAutoInitializeServicesRequired);

    my $isAutoInitializeServicesApplicable = $configuration->isAutoInitializeServicesApplicableParameterCallback($self->{_param}, $self->{_paramValKey}, $value);
    if ($isAutoInitializeServicesApplicable) {
        if($configuration->checkRequiresTenantUserCredentials() && $configuration->getValue('AutoInitializeServices')){
            $configuration->setSkip('TenantUser', 0);
            $configuration->setSkip('SQLTenantUserPassword', 0);
            $configuration->setDefault('TenantUser', $configuration->getValue('SystemUser')) if(defined $configuration->getValue('SystemUser'));
            $configuration->setDatabaseToTenantUserCredentialsParameter($configuration->{params}->{'TenantUser'});
            $configuration->setDatabaseToTenantUserCredentialsParameter($configuration->{params}->{'SQLTenantUserPassword'});
        }
    }
    return 1;
}

sub onMapValueChange{
    my ($self, $valKey, $value, $configuration) = @_;
    $self->{_paramValKey} = $valKey;
    return $self->onValueChange($value,$configuration);
}
1;
