package SDB::Install::Configuration::OfficeClient;

use SDB::Install::Configuration::AnyConfig;
use SDB::Install::SysVars;
use SDB::Install::System qw(getSysProgPath);
use SDB::Install::SAPSystem qw(CollectSAPSystems);
use SDB::Install::Globals qw($gProductName $gProductNameOfficeClient
    $gShortProductNameOfficeClient);
use SAPDB::Install::Hostname;

use strict;


our @ISA = qw(SDB::Install::Configuration::AnyConfig);
our $section = 'OfficeClient';


sub InitDefaults {
    my (
        $self,
        $kit
    ) = @_;
    if (defined $kit){
        if ($kit->is64bit()){
            $self->{modeStr} = '64bit';
        }
        else{
            $self->{modeStr} = '32bit';
        }
    }
    return 1;
}

sub new{
    my $self = shift->SUPER::new (@_);
    my $order = 0;
    $self->{params} = {
        'PATH' => {
            'str' => 'Installation Path',
            'order' => $order++,
            'opt' => 'path',
            'type' => 'path',
            'section' => $section,
            'default' => join ($path_separator, getSysProgPath (), 'SAP', $gProductNameOfficeClient),
            'value' => join ($path_separator, getSysProgPath (), 'SAP', $gProductNameOfficeClient),
            'init_with_default' => 1,
            'mandatory' => 1,
            'set_interactive' => 0
        },
        'Driver Name' => {
            'str' => 'ODBC Driver Name',
            'order' => $order++,
            'type' => 'string',
            'section' => $section,
            'value' => "$gProductName for MS Excel",
            'set_interactive' => 1
        }
    };
    return $self;
}

sub getProductName{
    return $gProductNameOfficeClient . (defined $_[0]->{modeStr} ? ' ' . $_[0]->{modeStr} : '');
}

sub getShortProductName{
    return $gShortProductNameOfficeClient;
}

sub isInstallationSelected{
    return $_[0]->isValuePreset ('PATH');
}

1;
