package SDB::Install::Configuration::Rename;

use strict;
use SDB::Install::Configuration::AnyRename;
use SDB::Install::Globals   qw ($gProductNameSystem
                                $gSapmntDirUx
                                $gSapsysGroupIdDefault
                                $gXSParametersRenameConstraint);
use SDB::Install::SAPSystem qw (ExistsInstanceNumber);
use SDB::Install::SysVars   qw ($isWin $path_separator);
use LCM::Configuration::ParametersCreator;
# use SDB::Install::DebugUtilities qw(dumpThings);

use parent qw(SDB::Install::Configuration::AnyRename);

our $section = 'Rename';

#-------------------------------------------------------------------------------
# Initialization
# Returns int retCode

sub InitDefaults{
    my ($self) = @_;
    my $rc = $self->SUPER::InitDefaults ();
    my ($sapmnt,$sid);

    $self->_addListeners();
    if (!defined $self->getDefault('Target')) {
        $self->setDefault('Target', $gSapmntDirUx);
    }

    foreach my $instance ('00','01','02','03','04','05','06','07', '08', '09', 10..97){
        if (!defined SDB::Install::SAPSystem::ExistsInstanceNumber ($instance)){
            $self->setDefault('InstanceNumber', $instance);
            last;
        }
    }
    return $rc;
}


#-------------------------------------------------------------------------------
# Checks the option 'internal_network'.
sub checkInternalNetwork {

    my ($self, $value) = @_;
    return $self->checkInternalNetworkOnly($value);
}


#-------------------------------------------------------------------------------
sub checkListenInterface {

    my ($self, $value) = @_;
    return $self->checkListenInterfaceOnly($value);
}


#-------------------------------------------------------------------------------
# Checks validity of the system administrator password used to stop the system

sub checksrcPasswd {

    my ($self, $password) = @_;

    if (!$self->SUPER::checksrcPasswd($password)) {
        return 0;
    }

    my $oldSID = $self->getValue('SID');
    my $newSID = $self->getValue('newSID');

    if ($oldSID eq $newSID) {
        my $newUser = new SDB::Install::NewDBUser($newSID);
        if ($newUser->exists()) {
            $self->{params}->{Password}->{value} = $password;
        }
    }

    return 1;
}


#-------------------------------------------------------------------------------
# This method is called from handleInitParams and initializes succeeding
# parameters (hash 'params') on slave hosts.
#
# Parameter: hash $data  *)
#
#    *) contains the content of the persistent file created for slaves by
#       the master (filename: '.../HDB<nr>/<host>/<persistentFileName>')
#
# Returns int retCode

sub handleSlaveInitParams{
    my ($self, $data) = @_;
    $self->SUPER::handleSlaveInitParams ($data);
    my $sapSys     = $self->{sapSys};
    my $sid        = $sapSys->get_sid ();
    my $instance   = $self->getOwnInstance();
    my $params     = $self->{params};
    my $instanceNr = $instance->get_nr();

    if ($self->isCheckOnly()) {
        $self->setSkip('newSID');
    }
    else {
        if (!defined $data) {
            $self->PushError("Status file '$self->{pers_fn_reg_rename}' missing");
            return undef;
        }
        $params->{newSID}->{value} = $sid;
        if (defined $data->{oldSID}){
            $params->{SID}->{value} = $data->{oldSID};
        }
        if (defined $data->{oldInstanceNumber}){
            $params->{oldInstanceNumber}->{value} = $data->{oldInstanceNumber};
        }
        $params->{InstanceNumber}->{value} = $instanceNr;
        $params->{AutoStart}->{value}      = $data->{AutoStart};

        if ($data->{initUserHomeDir}){
            $params->{InitUserHomeDir}->{value} = 1;
        }

        if (defined $data->{oldHost}) {
            $self->{oldHost} = $data->{oldHost};
        }
        my $noHostStart = 0;
        if (defined($data->{isNoHostStart})) {
            $noHostStart = $self->{isNoHostStart} = $data->{isNoHostStart};
        }

        if (defined $data->{RevertToSnapshot} && !$noHostStart){
            $self->setValue('RevertToSnapshot', $data->{RevertToSnapshot});
        }

        if (defined $data->{TenantMap} && $data->{RevertToSnapshot}){
            $self->setSkip('TenantMap',0);
            $params->{TenantMap}->{value} = $data->{TenantMap};
        }

        if ($data->{isRenameAccelerator}) {

            $self->{isRenameAccelerator} = 1;
            $self->{oldUidAccelerator}   = $data->{oldUidAccelerator};
            $self->{oldGidAccelerator}   = $data->{oldGidAccelerator};

            if (exists $params->{AcceleratorDataPath}) {

                $params->{AcceleratorDataPath}->{value} =
                    $data->{AcceleratorDataPath};

                $params->{AcceleratorDataPath}->{_originPath} =
                    $data->{oldAcceleratorDataPath};
            }

            if (exists $params->{AcceleratorLogPath}) {

                $params->{AcceleratorLogPath}->{value} =
                    $data->{AcceleratorLogPath};

                $params->{AcceleratorLogPath}->{_originPath} =
                    $data->{oldAcceleratorLogPath};
            }
        }

        if ($data->{isRenameExtendedStorage}) {

            $self->{isRenameExtendedStorage} = 1;
            $self->{oldUidEs} = $data->{oldUidEs};
            $self->{oldGidEs} = $data->{oldGidEs};

            if (exists $params->{EsDataPath}) {
                $params->{EsDataPath}->{value}       = $data->{EsDataPath};
                $params->{EsDataPath}->{_originPath} = $data->{oldEsDataPath};
            }

            if (exists $params->{EsLogPath}) {
                $params->{EsLogPath}->{value}       = $data->{EsLogPath};
                $params->{EsLogPath}->{_originPath} = $data->{oldEsLogPath};
            }
        }

        if ($data->{isRenameXS2}) {
            $self->{isRenameXS2} = 1;
        }
        if($data->{oldXsEaDataPath}){
            $params->{XsEaDataPath}->{_originPath} = $data->{oldXsEaDataPath};
        }

        my $rc = $self->tryHandleExistingGroupAndUser
                                          ($self->getSysAdminUserName($sid), 1);
        if (!$rc) {
            return $rc;
        }

        $rc = $self->handleSlaveInitUserParams();
        if (!$rc) {
            return $rc;
        }
    }

    foreach my $param (qw (ChangeSystemPasswd HostMap)){
        $self->{params}->{$param}->{skip} = 1;
    }
    return 1;
}


#-------------------------------------------------------------------------------
# Constructor
sub new{
    my $self  = shift->SUPER::new (@_);
	my $order = 0;
    my $datapathString = 'Location of Data Volumes';
    my $logpathString  = 'Location of Log Volumes';
	
	$self->{params} = {
        'SkipHostagentCalls' => $self->getParamSkipHostagentCalls($order++, $section),
        'CheckOnly'   => $self->getParamCheckOnly  ($order++, $section),
        'IsRegister'  => $self->getParamIsRegister($order++, $section),
        'ShowPending' => $self->getParamShowPending($order++, $section),
        'InitUser'    => $self->getParamInitUser   ($order++, $section, undef, 'Target'),
        ($isWin
            ? ('Drive'  => $self->getParamDrive ($order++, $section),
               'Domain' => $self->getParamDomain($order++, $section),
              )
            : ('Target' => $self->getParamTarget($order++, $section), )
         ),
        'RemoteExecution'    => $self->getParamRemoteExecution ($order++, $section),
        'UseHttp'            => $self->getParamUseHttp         ($order++, $section),
        'InstallHostagent'   => $self->getParamInstallHostagent($order++, $section),
	    'SID'                => $self->getParamSID             ($order++, $section),
        'newSID'             => $self->getParamNewSID          ($order++, $section),
        'SSOCertificate'     => $self->getParamSSOCertificate  ($order++, $section),
        'IsRegisterLSS'      => $self->getParamIsRegisterLSS   ($order++, $section),
        'InstanceNumber'     => $self->getParamInstanceNumber  ($order++, $section, 'Target Instance Number', 0),
        'HostMap'            => $self->getParamHostMap         ($order++, $section),
        'SystemUsage'        => $self->getParamSystemUsage     ($order++, $section),
        'BasePathDataVolumes'=> $self->getParamBasePath ($order++, $section, 'datapath',      $datapathString),
        'BasePathLogVolumes' => $self->getParamBasePath ($order++, $section, 'logpath',       $logpathString),
        'BasePathDataBackup' => $self->getParamBasePath ($order++, $section, 'databackuppath','Location of Data Backups'),
        'BasePathLogBackup'  => $self->getParamBasePath ($order++, $section, 'logbackuppath', 'Location of Log Backups'),
        'BasePathCatalogBackup' => $self->getParamBasePath ($order++, $section, 'catalogbackuppath','Location of Catalog Backups'),
        'EsDataPath'         => $self->getParamEsDataPath($order++,$section, 1, 0),
        'EsLogPath'          => $self->getParamEsLogPath($order++, $section, 1, 0),
        'AcceleratorDataPath'=> $self->getParamAcceleratorDataPath($order++, $section, 1, 0),
        'AcceleratorLogPath' => $self->getParamAcceleratorLogPath ($order++, $section, 1, 0),
        'XsEaDataPath'       => $self->getParamXsEaDataPath($order++, $section, $gXSParametersRenameConstraint),
        'XsDomainName'         => $self->getParamXsDomainName($order++, $section, $gXSParametersRenameConstraint),
        'TenantMap'          => $self->getParamTenantMap($order++, $section),
        'Scope'              => $self->getParamScope             ($order++, $section),
        'ScopeInteractive'   => $self->getParamScopeInteractive  ($order++, $section),
        'SystemIsOffline'    => $self->getParamSystemIsOffline   ($order++, $section ),
        'srcPasswd'          => $self->getParamSrcPasswd         ($order++, $section),
        'Password'           => $self->getParamPassword          ($order++, $section),
        'RevertToSnapshot'   => $self->getParamRevertToSnapshot  ($order++, $section),
        'ChangeSystemPasswd' => $self->getParamChangeSystemPasswd($order++, $section, 0),
        'SystemUser'         => $self->getParamSystemUser        ($order++, $section, 1),
        'SrcSQLSysPasswd'    => $self->getParamSrcSQLSysPasswd   ($order++, $section),
        'TrgSQLSysPasswd'    => $self->getParamTrgSQLSysPasswd   ($order++, $section),
        ($isWin
            ? ('HostagentUserName' => $self->getParamHostagentUserName($order++, $section)
              )
            : ('InstallSSHKey'     => $self->getParamInstallSSHKey($order++, $section),
               'RootUser'          => $self->getParamRootUser     ($order++, $section),
               'RootPassword'      => $self->getParamRootPassword ($order++, $section),
              )
        ),
        'SkipHostagentPw'   => $self->getParamSkipHostagentPw  ($order++, $section),
        'HostagentPassword' => $self->getParamHostagentPassword($order++, $section),
        'InternalHostnameResolution' => $self->getParamInternalHostnameResolution($order++, $section),
        'ListenInterface'   => $self->getParamListenInterface  ($order++, $section, 1),
        'InternalNetwork'   => $self->getParamInternalNetwork  ($order++, $section, 1),
        'KeepUser'          => $self->getParamKeepUser         ($order++, $section, undef, 'Source'),
        ($isWin
            ? ()
            : ('KeepUserHomeDir'   => $self->getParamKeepUserHomeDir($order++, $section, undef, 'Source'),
               'InitUserHomeDir'   => $self->getParamInitUserHomeDir($order++, $section, undef, 'Target'),
               'HomeDir'           => $self->getParamHomeDir        ($order++, $section, '/usr/sap/$newSID/home'),
               'Shell'             => $self->getParamShell          ($order++, $section),
               'UID'               => $self->getParamUID            ($order++, $section),
               'GID'               => $self->getParamGID            ($order++, $section, $gSapsysGroupIdDefault, 0),
               'SkipModifySudoers' => $self->getParamSkipModifySudoers($order++, $section),
               'XSSpaceUserIdSAP'  => GetParamXSSpaceUserIdSAP($order++, $section, $gXSParametersRenameConstraint),
               'XSSpaceUserIdProd' => GetParamXSSpaceUserIdProd($order++, $section, $gXSParametersRenameConstraint),
            )
        ),
        'KeepXsUsers'       => $self->getParamKeepXsUsers      ($order++, $section, $gXSParametersRenameConstraint),
        'AutoStart'         => $self->getParamAutoStart        ($order++, $section, 1),
        'NoStart'           => $self->getParamNoStart          ($order++, $section,
                               "Do not start $gProductNameSystem but start service (sapstartsrv) instead",
                               "Does not start $gProductNameSystem but starts service (sapstartsrv) instead",
                               0), # not hidden
        'oldInstanceNumber' => $self->getParamOldInstanceNumber ($order++, $section),
        'TrgSysReplicationCleanUp' => $self->getParamTrgSysReplicationCleanUp ($order++, $section),
        'OldBasePathDataVolumes'   => $self->getParamBasePath($order++, $section, undef, $datapathString),
        'OldBasePathLogVolumes'    => $self->getParamBasePath($order++, $section, undef, $logpathString),
    };
    $self->defineLSSRenameParams();
    $self->{params}->{SID}->{opt} = 'source_sid';
    $self->{params}->{SID}->{str} = 'Source System ID';

    # Target is set by SBD::Install::Installer::getInstallation
    for my $paramID ('Target', 'OldBasePathDataVolumes', 'OldBasePathLogVolumes') {
        $self->setHidden($paramID);
    }

    $self->setDefault('AcceleratorDataPath', undef);
    $self->setDefault('AcceleratorLogPath', undef);
    $self->setDefault('EsDataPath', undef);
    $self->setDefault('EsLogPath', undef);

    $self->setSummaryOrder(['Target',
                            'SID',
                            'newSID',
                            'oldInstanceNumber',
                            'InstanceNumber',
                            'HostMap',
                            'SystemUsage',
                            'InitUser',
                            'HomeDir',
                            'InitUserHomeDir',
                            'Shell',
                            'UID',
                            'GID',
                            'XSSpaceUserIdSAP',
                            'XSSpaceUserIdProd',
                            'KeepUser',
                            'KeepUserHomeDir',
                            'SystemUser',
                            'BasePathDataVolumes',
                            'BasePathLogVolumes',
                            'BasePathDataBackup',
                            'BasePathLogBackup',
                            'BasePathCatalogBackup',
                            'TenantMap',
                            'ListenInterface',
                            'InternalNetwork',
                            'InstallHostagent',
                            'Scope',
                            'RemoteExecution',
                            'RootUser',
                            'HostagentUserName',
                            'CheckOnly',
                            'AutoStart',
                            'NoStart',
                           ]);
	
	return $self;
}

#-------------------------------------------------------------------------------
# Returns a hash containing entries of the parameter 'oldInstanceNumber'.
# In case of slave rename the parameter value is read from the pers-file.
# In case of master rename the parameter is used for the summary only.

sub getParamOldInstanceNumber {
    my ($self, $order, $section) = @_;
    return {
        'order'   => $order,
        'type'    => 'string',
        'section' => $section,
        'value'   => undef,
        'skip'    => 1,
        'hidden'  => 1,
        'str'     => 'Source Instance Number',
    };
}


#-------------------------------------------------------------------------------
# Sets the source system ID.
# In case of a slave the subroutine 'checkSID' sets the old SID read from the
# pers-file.

sub setSID {
    my ($self, $sid) = @_;
    if (!$self->checkSID ($sid)){
        return 0;
    }
    if ($self->{isSlave} && defined $self->{params}->{SID}->{value}) {
        # during slave operation the value is set in handleSlaveInitParams ()
        return 1;
    }
    $self->{params}->{SID}->{value} = $sid;
    return 1;
}


#-------------------------------------------------------------------------------
# Collects information of remote hosts and checks SID, instance number,
# and sidadm properties. These values have to belong to this SAP HANA system
# or have to be free.

sub CollectOtherHostInfos {
    my ($self, $isNotVerbose) = @_;

    my $savedSID          = $self->{_oldOrNewSID};
    my $sapSys            = $self->getSAPSystem();
    my $mountPointSID     = $sapSys->getTargetSID() if (defined $sapSys);
    $self->{_oldOrNewSID} = (defined $mountPointSID) ? $mountPointSID
                                                     : $self->getValue('SID');

    my $rc = $self->SUPER::CollectOtherHostInfos($isNotVerbose);

    $self->{_oldOrNewSID} = $savedSID;

    return $rc;
}

#-------------------------------------------------------------------------------
# Writes a summary of the parameters onto the console and into the log file.

sub displayParameterSummary {

	my ($self) = @_;

    my $oldNum = $self->{params}->{oldInstanceNumber};
    $oldNum->{skip}   = 0;
    $oldNum->{hidden} = 0;
    $oldNum->{value}  = $self->getOwnInstance()->get_nr() if (!defined $oldNum->{value});

    $self->SUPER::displayParameterSummary();

    $oldNum->{skip}   = 1;
    $oldNum->{hidden} = 1;
}


sub shouldWarnIfCalledStandalone{
    my ($self) = @_;
    return $self->_calledStandaloneCriterion();
}

sub getExeName{
    return "hdbrename";
}

sub getResidentHdblcmPath{
    my ($self) = @_;
    return $self->_constructResidentHdblcmPath();
}

1;
