package SDB::Install::Configuration::ServerUninstParams;

use base SDB::Install::Configuration::Uninstallation;
use SDB::Install::SysVars qw ($isWin);
use SDB::Install::Globals qw ($gXSParametersGenericConstraint);

# Creates the hash 'params' that provides pass-through parameters.
# ServerUninstallation does not use this hash, it uses $self->{options} instead.

sub new{
    my $self = shift->SUPER::new (@_);
    my $order = 0;

    $self->{params} = {
         'SkipHostagentCalls' => $self->getParamSkipHostagentCalls($order++, $section),
         'InstallSSHKey' => $self->getParamInstallSSHKey($order++, $section),
         'RemoteExecution'  => $self->getParamRemoteExecution ($order++, $section),
         'RootUser'      => $self->getParamRootUser     ($order++, $section),
         'RootPassword'  => $self->getParamRootPassword ($order++, $section),
         'KeepUser'      => $self->getParamKeepUser     ($order++, $section),
         (
             !$isWin
             ? (
                  'KeepUserHomeDir'     => $self->getParamKeepUserHomeDir($order++, $section),
                  'SkipModifySudoers'   => $self->getParamSkipModifySudoers($order++, $section),
               )
             : ()
         ),
         'KeepXsUsers'       => $self->getParamKeepXsUsers       ($order++, $section, $gXSParametersGenericConstraint),
         'Force'             => $self->getParamForce             ($order++, $section),
         'IgnoreNotExisting' => $self->getParamIgnoreNotExisting ($order++, $section)
    };

	return $self;
}

1;
