package SDB::Install::Configuration::XMLConfigParser;

use SDB::Install::XMLParser;
use SDB::Install::Base;
use strict;

our @ISA = qw (SDB::Install::XMLParser SDB::Install::Base);

our $tagConfig       = 'install_configuration';
our $tagParams       = 'params';
our $tagTimeouts     = 'timeouts';
our $tagIgnoreValues = 'ignore_values';

sub new{
    my $self = shift->SUPER::new ();
    return $self;
}


sub parse{
    my ($self,$buff) = @_;

    eval{
        $self->SUPER::parse ($buff);
    };

    if ($@){
        $self->setErrorMessage ("Error parsing xml input: $@");
        return undef;
    }

    my $node = $self->getElementByTagName ($tagConfig);

    if (!defined $node){
        $self->setErrorMessage ("No '$tagConfig' tag found in xml");
        return undef;
    }
    my $attr = $node->{attr};
    if (!$attr || !defined $attr->{class}){
        $self->setErrorMessage ("'class' attribute of '$tagConfig' tag not found");
        return undef;
    }
    $self->{class} = $attr->{class};

    if (defined $attr->{'installer_version'}){
        $self->{installer_version} = $attr->{'installer_version'};
    }

    if (defined $attr->{'component_version'}){
        $self->{component_version} = $attr->{'component_version'};
    }


    return 1;
}

sub getParams{
    my ($self) = @_;
    if (!defined $self->{root}){
        $self->setErrorMessage ("No parse tree");
        return undef;
    }

    my $params = {};
    my ($param, $id, $prop_node);

    my $node = $self->getElementByTagName ($tagParams);

    if (!defined $node){
        $self->setErrorMessage ("No '$tagParams' tag found in xml");
        return undef;
    }

    $node = $node->{child};

    while (defined $node && $node->{type} eq 'param'){
        $id = $node->{attr}->{id};
        if (!defined $id){
            $self->appendErrorMessage ("No parameter id found");
            next;
        }
        if (exists $params->{$id}){
            $self->appendErrorMessage ("Parameter id '$id' already added");
            next;
        }
        $param = {};
        $params->{$id} = $param;
        $prop_node = $node->{child};
        while (defined $prop_node){
            $param->{$prop_node->{type}} = $prop_node->{content};
            $prop_node = $prop_node->{neighbor};
        }
        $node = $node->{neighbor};
    }
    return $params;
}

sub getTimeoutValues{
    my ($self) = @_;
    if (!defined $self->{root}){
        $self->setErrorMessage ("No parse tree");
        return undef;
    }

    my $params = {};

    my $node = $self->getElementByTagName ($tagTimeouts);

    if (!defined $node){
        return undef;
    }

    $node = $node->{child};

    my @timeouts;
    my $timeout;

    while (defined $node && $node->{type} eq 'timeout'){
        $timeout = $node->{content};
        if (defined $timeout && $timeout){
            push @timeouts, $timeout;
        }
        $node = $node->{neighbor};
    }
    return \@timeouts;
}

sub getIgnoreValues{
    my ($self) = @_;
    if (!defined $self->{root}){
        $self->setErrorMessage ("No parse tree");
        return undef;
    }

    my $params = {};

    my $node = $self->getElementByTagName ($tagIgnoreValues);

    if (!defined $node){
        return undef;
    }

    $node = $node->{child};

    my @ignoreValues;
    my @hiddenIgnoreValues;
    my $ignoreValue;

    while (defined $node && $node->{type} eq 'ignore_value'){
        $ignoreValue = $node->{content};
        if (defined $ignoreValue && $ignoreValue){
            if (defined $node->{attr} && $node->{attr}->{hidden}){
                push @hiddenIgnoreValues, $ignoreValue;
            }
            else{
                push @ignoreValues, $ignoreValue;
            }
        }
        $node = $node->{neighbor};
    }
    return \@ignoreValues,\@hiddenIgnoreValues;
}

sub getConfigClass{
    return $_[0]->{class};
}

sub getConfigInstallerVersion{
    return $_[0]->{installer_version};
}

sub getConfigComponentVersion{
    return $_[0]->{component_version};
}


1;
