package SDB::Install::EclipseIniFile;

use SDB::Install::SysVars qw ($isWin);
use SDB::Install::TextFile;
use strict;

our @ISA = qw (SDB::Install::TextFile);

sub parse{
	my ($self) = @_;
	if (defined $self->{options}){
		return 1;
	}
	my (@options, @vmargs);
	my ($line, $section, $key, $value);
	my $vmargs_section = 0;
	my $count = -1;
	foreach my $lineNr (0.. (scalar (@{$self->{_buffer}}) - 1)){
		$line = $self->{_buffer}->[$lineNr];
		chomp ($line);
		if ($line =~/^\s*#/){
			next;
		}
		$line =~s/^\s*//;
		$line =~s/\s*$//;

		if ($line =~/^\-vmargs/) {
			$vmargs_section = 1;
			next;
		}
		if ($line =~/^\-/ && !$vmargs_section) {
			# new option
			$count++;
			push @options, [$line];
		} else {
			if ($vmargs_section) {
				push @vmargs, $line;
			} else {
				push @{$options[$count]}, $line;
			}
		}
	}
	$self->{options} = \@options;
	$self->{vmargs} = \@vmargs;
	return 1;
}

sub setOption{
	my ($self, $option) = @_;

	if (!defined $self->{options}) {
		$self->AddError ("Cannot edit file '$self->{fullname}': File was not parsed correctly");
		return undef;
	}

	# check if this option is already in the buffer
	my $replaced = 0;
	foreach my $opt (0.. (scalar(@{$self->{options}}) -1)) {
		if (!($self->{options}->[$opt]->[0] eq $option->[0])) {
			next;
		}
		# replace existing option
		my @newOption;
		foreach my $line (0.. (scalar(@{$option}) -1)) {
			push @newOption, $option->[$line];
		}
		$self->{options}->[$opt] = \@newOption;
		$replaced = 1;
	}

	# option is not in the buffer yet, prepare to add it
	if (!$replaced) {
		push @{$self->{options}}, $option;
	}

	# re-write buffer
	my @newBuffer;
	# write eclipse options to buffer
	foreach my $opt (0.. (scalar(@{$self->{options}}) -1)) {
		foreach my $line (0.. (scalar(@{$self->{options}->[$opt]}) -1)) {
			push @newBuffer, $self->{options}->[$opt]->[$line] . "\n";
		}
	}
	# write vmargs to buffer
	if (scalar(@{$self->{vmargs}})) {
		push @newBuffer, "-vmargs\n";
		foreach my $vmarg (0.. (scalar(@{$self->{vmargs}}) -1)) {
			push @newBuffer, $self->{vmargs}->[$vmarg] . "\n";
		}
	}

	# set buffer to new content
	$self->{_buffer} = \@newBuffer;
	# set write trigger
    $self->{_changed} = 1;

	$self->AddMessage ("Option added to file '$self->{fullname}': " . join(' ', @$option));
	return 1;
}

1;
