package SDB::Install::Gui::Dialogs::Install;

use Wx qw (
	wxEXPAND
    wxTOP
    wxALIGN_CENTER wxALL
	wxLEFT
    wxVERTICAL
    wxSUNKEN_BORDER
    wxALIGN_LEFT
    );

use base 'SAPDB::Install::Wizard::Dialog::Base';
use SAPDB::Install::Window::ExecPlan;
use SDB::Install::Gui::Design;
use SDB::Install::Gui::Dialogs::PackageProgressHandler;
use SDB::Install::Globals;
use strict;

sub new{
	my($self ) = shift->SUPER::new(@_);

	$self->{id} = 'install';
	$self->{name} = 'Install Software';
	
	my $text = "Installing software components";
	$self->{'caption'} = Wx::StaticText->new($self,-1,$text,[0,0],[-1,-1]);
	$self->{'caption'}->SetFont (SDBFONT_DialogTitle) if (!Wx::wxGTK1());
	
    my $top_sizer = Wx::BoxSizer->new(wxVERTICAL);
    $self->{'plan'} = $self->_createExecutionPlan();
    $top_sizer->Add($self->{'caption'},0,wxALIGN_LEFT | wxLEFT | wxTOP , 20);
    $top_sizer->Add($self->{'plan'},1,wxALL | wxEXPAND, 20);
    $self->SetSizer($top_sizer);
    $self->SetAutoLayout(1);
    $self->Layout;
    return $self;
}

sub DirectNavigationAllowed ($) {0}

sub init{
	my ($self,$config) = @_;

	my $app = Wx::wxTheApp();
    my $instconfig = $app->{instconfig};
	
	my $text;
    if ($instconfig->isa ('SDB::Install::Configuration::Generic')){
        $text = sprintf ('Installing %s Software', $instconfig->getProductName ());
    }
    elsif ($app->{kit}->IsDBStudioDistribution ()){
		$text = "Installing $gProductNameStudio Software";
	}
	elsif ($app->{kit}->isClient ()){
		$text = "Installing $gProductNameClient Software";
	}
    elsif ($app->{kit}->isOfficeClient ()){
        $text = "Installing ".$app->{instconfig}->getProductName () ." Software";
    }
	elsif ($config->{mode} eq 'install'){
		$text = "Installing Software of System %s ";
	}
	else{
		$text = "Updating Software of System %s";
	}
	$self->{'caption'}->SetLabel (sprintf ($text, defined $app->{sapSystem} ? $app->{sapSystem}->{_sid} : undef));

	$self->GetWizard()->KillPreviousDialogs ();

	return {'auto_next' => 1};
}


sub Process{
	my ($self,$config) = @_;
	
	my $app = Wx::wxTheApp();
	
	my $packageManager = $app->{kit};
	
	my $pp_handler = new SDB::Install::Gui::Dialogs::PackageProgressHandler ($self->{plan});
	
	$packageManager->SetProgressHandler ($self);	
	
	$packageManager->SetPackageProgressHandler ($pp_handler);
	
	if (!$app->{kit}->isServer () || $config->{mode} eq 'install'){
		my $rc = $app->install ();
		if (!defined $rc){
			Wx::wxTheApp()->ShowErrorMsg ('Installation failed', $app->getErrMsgLst ());
			$packageManager->SetProgressHandler ();
			$packageManager->SetPackageProgressHandler ();
			return  {'errstate' => 1};	
		}
	}
	else{
		my $inst = $app->{sapSystem};

	
		if (!defined $inst->OpenExclusive ()){
			$app->ShowErrorMsg ('Upgrade failed', $inst->getErrMsgLst());
			$packageManager->SetProgressHandler ();
			$packageManager->SetPackageProgressHandler ();
			return  {'errstate' => 1};	
		}
		

		my $instconfig = $app->{instconfig};
	
		if (!defined $inst->update ($instconfig->getValue ('Password'),
			$app->{kit}, $instconfig)){
			$app->ShowErrorMsg ('Upgrade failed', $inst->getErrMsgLst());
			$packageManager->SetProgressHandler ();
			$packageManager->SetPackageProgressHandler ();
			return  {'errstate' => 1};	
		}
	}
	$packageManager->SetProgressHandler ();
	$packageManager->SetPackageProgressHandler ();
	return {};
}

sub CallbackRefresh;
*CallbackRefresh = \&Wx::Yield;

sub Destroy{
	my ($self) = @_;
    
    #
    #   Destroy Sizer
    #
    
	if(defined $self->GetSizer){
		$self->GetSizer->Clear (1);
	}
    
    #
    #   Destroy elements
    #
    
    foreach my $element (  'plan',
						'caption'
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
	$self->SUPER::Destroy;
}


sub InitProgress($$$$){
	my ($self,$steps,$value,$names) = @_;
	my @steps;
	foreach my $name (@$names){
		push @steps, {'Label' => $name, 'State' => 'PENDING'};
	}
	$self->{'plan'}->init(\@steps,{'with_progress' => 1});
	$self->GetWizard()->LayoutDlg();
	Wx::Yield ();	
}


sub IncValue ($$){
	my ($self,$value) = @_;
	Wx::Yield ();	
}

sub IncRange ($$){
	my ($self,$value) = @_;
	Wx::Yield ();	
}


sub SetProgress ($$) {
	my ($self,$msg) = @_;
	Wx::Yield ();	
}


sub StepFinished{
    my ($self,$error) = @_;
    
    if ($error){
    	$self->{'plan'}->Next('FINISHED_ERROR');
    }
	else{
		
		$self->{'plan'}->SetProgress (100);
		$self->{'plan'}->Next ('FINISHED_SUCCESS');
    }
} 

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}

sub _createExecutionPlan {
	my ($self) = @_;
	return SAPDB::Install::Window::ExecPlan->new($self,-1);
}

1;
