#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: User selection options for Install oder Update NewDB software.

package SDB::Install::Gui::Dialogs::InstallUpdate;

use Wx qw (
    wxVERTICAL
    wxDefaultSize 
    wxLEFT
    wxSWISS
    wxNORMAL
    wxTOP
    wxBOTTOM
    wxBOLD
    wxRIGHT
    wxOK
    wxCENTRE
    wxICON_EXCLAMATION
    wxRB_GROUP
    );


use SAPDB::Install::Wizard::Dialog::Base;

#   Dialogs
use SDB::Install::Gui::Dialogs::SelectUpdate;
use SDB::Install::Gui::Dialogs::SystemProperties;
use SDB::Install::Gui::Dialogs::User;
use SDB::Install::Gui::Dialogs::VolumePaths;
use SDB::Install::Gui::Dialogs::SQLUser;
use SDB::Install::Gui::Dialogs::UpgradeParameter;
use SDB::Install::Gui::Dialogs::DBUpgradeRestart;
use SDB::Install::Gui::Dialogs::CreateInstance;
use SDB::Install::Gui::Dialogs::Preparing;
use SDB::Install::Gui::Dialogs::Summary;
use SDB::Install::Gui::Dialogs::Finalize;
use SDB::Install::Gui::Dialogs::Install;
use SDB::Install::SAPSystem;
use SDB::Install::Globals;
use SDB::Install::Gui::Design;
use strict;

our @ISA = qw (SAPDB::Install::Wizard::Dialog::Base);

our $selection = {
        'install' => {
                        'desc' => '',
                        'label' => sprintf ('&Install the %s', $gProductNameEngine),
                        'seq' => 1
                     },
        'update' => {
                        'desc' => '',
                        'label' => sprintf ('&Upgrade the %s', $gProductNameEngine),
                        'seq' => 2
                    }
	             };
                 
my $default_selection = 'install';

sub new{
	my($self ) = shift->SUPER::new(@_);
    
    $self->{id} = 'InstallUpdate';
    $self->{name} = 'Select Activity';
    
    #
    #   Sizer
    # 
    
    my $sizer = Wx::BoxSizer->new(wxVERTICAL);

    #
    #   Titel text
    #
    
    $self->{'titel'} = Wx::StaticText->new($self,-1,'Select what you want to do',[0,0],[-1,-1]);
    $self->{'titel'}->SetFont( SDBFONT_DialogTitle ) if (!Wx::wxGTK1());
    $sizer->Add($self->{'titel'},0,wxLEFT | wxRIGHT | wxTOP | wxBOTTOM ,20);

    #
    #   User choice
    #
    
    my @selection = sort {$selection->{$a}->{'seq'} <=> $selection->{$b}->{'seq'} } keys(%$selection);
    foreach my $comp (@selection){
        
        #Radio Buttons
        $self->{'rb_'.$comp} = Wx::RadioButton->new($self,-1,$selection->{$comp}->{'label'},[0,0],[-1,-1], $selection->{$comp}->{seq} == 1 ? wxRB_GROUP : ());
        $self->{'rb_'.$comp}->SetFont( SDBFONT_BoldText ) if (!Wx::wxGTK1());
        $sizer->Add($self->{'rb_'.$comp},0,wxLEFT | wxRIGHT ,20);
        $sizer->AddSpacer(6);

        #Set Description text
       #$self->{'text_desc'.$comp} = Wx::StaticText->new($self,-1,'',[-1,-1],);
        my $label = $selection->{$comp}->{'label'};
        $label =~ s/&//g;
        #$self->{'text_desc'.$comp}->SetLabel($selection->{$comp}->{'desc'});
        #$self->{'text_desc'.$comp}->SetFont ( SDBFONT_NormalText ) if (!Wx::wxGTK1());
       # $sizer->Add($self->{'text_desc'.$comp},0, wxLEFT, 38);        
        $sizer->AddSpacer(12);

        #Default Selection
        if($default_selection eq $comp){
            $self->{'rb_'.$comp}->SetValue(1);
        }
    }
    
    #
    #   Dialog stuff
    #
    
    $self->SetSizer($sizer);
    $self->Fit();
	$self->SetAutoLayout(1);
	$self->Layout();
    
    #
    #   disable install and update if needed
    #
    
    my ($kit) = (
           Wx::wxTheApp->{kit},    #packages
    );
    
    my $disable_install = 0;
    my $disable_update = 0;
    
    # No packages available
    if ($kit->GetNumberOfPackages < 1) { 
        $disable_install = 1;
        $disable_update = 1;
    }

	my $systems = CollectSAPSystems ();
	my $found = 0;
	
	foreach my $system (values %$systems){
		if ($system->hasNewDB ()){
			$found = 1;
			last;
		}
	}

	if (!$found){
		$disable_update = 1;
	}


    if ($disable_install) { # set Install option off
        $self->{'rb_install'}->Disable;
        $self->{'rb_install'}->SetValue(0);
        #$self->{'text_descinstall'}->Disable;
    }
    if ($disable_update) { # set update option off
	        $self->{'rb_update'}->Disable;
            $self->{'rb_update'}->SetValue(0);
           #$self->{'text_descupdate'}->Disable;
    }
    
   return $self;
}

sub init(){
	my ($self,$config) = @_;

	 my $app = Wx::wxTheApp();
	 
	if (defined $app->{options}->{action}){
		if ($app->{options}->{action} eq 'install'){
			$self->{'rb_install'}->SetValue(1);
			return {'auto_next' => 1};
		}
		elsif ($app->{options}->{action} eq 'update'){
			$self->{'rb_update'}->SetValue(1);
			return {'auto_next' => 1};
		}
		
	}

	
	$self->Layout();
	$self->Show(1);

	$self->Layout;
		
	return {}; 
}

sub Process{
	my ($self,$config) = @_;
    
    #
    # Who's selected?
    #
    foreach my $comp (keys(%$selection)){
        if($self->{'rb_'.$comp}->GetValue){
            $config->{'mode'} = $comp;
        }   
    }
    
    #
    #   show warning if there are no packages available
    #
   
   my $app = Wx::wxTheApp();
   
    my ($kit) = (
           $app->{kit},    #packages
    );
	#
    # Add next frames
    #
    
    my %rv;
    
	if($config->{'mode'} eq 'install'){
		$app->{instconfig} = new SDB::Install::Configuration::NewDB ($app,
			$app->{options}, $app->{configfile});
		$app->{instconfig}->InitDefaults ($kit);
		my $packageManagerCollection = $app->{'packageManagerCollection'};
		if (defined $packageManagerCollection){
			my $item =  $packageManagerCollection->getPackageManagersByKey ('kit');
			if (defined $item){
				my (undef,$removed) = @{$packageManagerCollection->removePackageManagersByKey ('kit')};
				if (defined $removed){
					$removed->FreePackages ();
					$kit->Reset();
				}else{
					$app->ShowErrorMsg ('Error removing installation', $packageManagerCollection->getErrMsgLst());
					return undef;
				}	
			}
		}
		
		
		my $wizard = $self->GetWizard ();
		$wizard->AddCondensedStep ('questions', 'Configure Installation');

		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Summary ($wizard));

		if ($kit->HasDBKernel ()){
			$wizard->AddCondensedStep('install', 'Installation');
		}
		else{
			$wizard->AddDialog(new SDB::Install::Gui::Dialogs::Install ($wizard));
		}
		
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Finalize ($wizard));
		
		$wizard->terminateChain ();
		
				
		
		my @dlg_ids;
		
		my $dlg = new SDB::Install::Gui::Dialogs::SystemProperties ($wizard);

		$wizard->InsertDialog ($dlg, $self->GetID (), 'questions');
		push @dlg_ids, $dlg->GetID;
		
		$dlg = new SDB::Install::Gui::Dialogs::User ($wizard);

		$wizard->InsertDialog ($dlg, $dlg_ids[$#dlg_ids], 'questions');
		push @dlg_ids, $dlg->GetID;

		$dlg = new SDB::Install::Gui::Dialogs::VolumePaths ($wizard);

		$wizard->InsertDialog ($dlg, $dlg_ids[$#dlg_ids], 'questions');
		push @dlg_ids, $dlg->GetID;
		
		$dlg = new SDB::Install::Gui::Dialogs::SQLUser ($wizard);

		$wizard->InsertDialog ($dlg, $dlg_ids[$#dlg_ids], 'questions');
		push @dlg_ids, $dlg->GetID;
		
		$dlg = new SDB::Install::Gui::Dialogs::Preparing ($wizard);
		$wizard->InsertDialog ($dlg, $dlg_ids[$#dlg_ids], 'questions');

		push @dlg_ids, $dlg->GetID;
	
		if ($kit->HasDBKernel ()){
			$dlg = new SDB::Install::Gui::Dialogs::Install ($wizard);
			$wizard->InsertDialog ($dlg, 'summary', 'install');
			$dlg = new SDB::Install::Gui::Dialogs::CreateInstance ($wizard);
			$wizard->InsertDialog ($dlg, 'install', 'install');
		}
	}

	if($config->{'mode'} eq 'update'){
		$app->{instconfig} = new SDB::Install::Configuration::Upgrade (
			$app->{options}, $app->{configfile});
		$app->{instconfig}->InitDefaults ($app->{kit});
		my $wizard = $self->GetWizard ();
			
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::SelectUpdate ($wizard));	
		
		my $dlg = new SDB::Install::Gui::Dialogs::UpgradeParameter ($wizard);
		
		$wizard->AddDialog ($dlg);
		$wizard->AddCondensedStep ('update_properties', 'Prepare Database Upgrade');
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Summary ($wizard));
		$wizard->AddCondensedStep('install', 'Upgrade');
		$wizard->AddDialog (new SDB::Install::Gui::Dialogs::Finalize ($wizard));
		$wizard->terminateChain ();
			
		my $last_id = $dlg->GetID();
		
		$dlg = new SDB::Install::Gui::Dialogs::Preparing ($wizard);
		$wizard->InsertDialog ($dlg, $last_id, 'update_properties');
		
		$dlg = new SDB::Install::Gui::Dialogs::Install ($wizard);
		$dlg->{name} = 'Update Software';
		$wizard->InsertDialog ($dlg, 'summary', 'install');
				
		$dlg = new SDB::Install::Gui::Dialogs::DBUpgradeRestart ($wizard);
		$wizard->InsertDialog ($dlg, 'install', 'install');
		$wizard->init ();	
	}
	

    #
    # now we know the configuration class
    # => parse the entire argument vector (@ARGV)
    #

    $app->{_config_selected} = 1;
    my $rc = $app->InitCmdLineArgs (\@ARGV);

    if ($app->errorState){
        $app->ShowErrorMsg ('Installation failed', $app->getErrMsgLst());
        return {'errstate' => 1};
    }

    if (defined $app->{return}){
        # InitCmdLineArgs() told us to exit application here
        # this happens for example with --help
        # control flow goes back to main function
        $app->ExitMainLoop ();
        return;
    }

    if (!defined $app->checkSystemRequirements ()){
        $app->ShowErrorMsg ('Installation failed', $app->getErrMsgLst());
        return {'errstate' => 1};
    }


    #
    # disable software component selection so far
    # => select all packages
    #
    $app->{kit}->SelectAllPackages ();
	return \%rv;
}

sub SetBusy{
	my ($self,$busy) = @_;
	if(not defined $busy or $busy){
        $self->Enable(0);
	}
	else{
        $self->Enable(1);
	}
	return 1;
}

sub BackInit{
    my ($self,$config) = @_;
    if (exists $config->{'mode'}) { delete $config->{'mode'}; }
    
    $self->GetWizard ()->unterminateChain ();
	       
    return {};
}

#>----------------------------------Seek&Destroy Stuff---------------------------------<#

sub Destroy{
	my ($self) = @_;
    
    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
        $self->GetSizer()->Clear (1);
    }

    #
    #   Destroy selection elements
    #
    foreach my $comp (keys(%$selection)){
       if(defined $self->{'rb_'.$comp}){
            #$self->{'rb_'.$comp}->Destroy;
            delete $self->{'rb_'.$comp};
        }
        if(defined $self->{'text_desc'.$comp}){
                    #$self->{'text_desc'.$comp}->Destroy;
                    delete $self->{'text_desc'.$comp};
        }
    }
    
    #
    #   Destroy other elements
    #
    foreach my $element ( 'titel', 
                      ) {
        if(defined $self->{$element}){
            #$self->{$element}->Destroy;
            delete $self->{$element};
        }
    }
    
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;
