#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Prepare installation. This dialog shows only a progress bar.

#todo: skip backinit dialog

package SDB::Install::Gui::Dialogs::Preparing;

use Wx qw (
    wxGA_HORIZONTAL 
    wxALIGN_CENTER_HORIZONTAL 
    wxALIGN_CENTER_VERTICAL
    wxALL
    wxSWISS
    wxNORMAL
    wxLEFT
    wxHORIZONTAL
    wxRIGHT
    wxBOTTOM
    wxVERTICAL
    wxEXPAND
    wxTOP
    wxBOLD
    );

use base SAPDB::Install::Wizard::Dialog::Base;

use SDB::Install::Gui::Design;

sub new {
    my ($self) = shift->SUPER::new(@_);
    
    $self->{id} = 'prepare';

    my $sizer = Wx::BoxSizer->new(wxVERTICAL);
    
    #
    #   Title
    #

    $self->{'titel_big'} = Wx::StaticText->new($self, -1, "Checking software, please wait...",);
    $self->{'titel_big'}->SetFont( SDBFONT_DialogTitle ) if (!Wx::wxGTK1());
    $sizer->AddSpacer(4);
    $sizer->Add($self->{'titel_big'},0,wxLEFT | wxTOP,16);
    $sizer->AddSpacer(40);
    
    #Static Box
    $self->{'static_box'} = Wx::StaticBox->new($self,-1,'');
    $self->{'staticbox_sizer'} = Wx::StaticBoxSizer->new($self->{'static_box'},wxVERTICAL);
    
    #
    # Progress bar and text
    #
    
    my $progresssizer = Wx::BoxSizer->new(wxHORIZONTAL);
    $self->{'progressbar'} = Wx::Gauge->new ($self, -1, 100, [-1,-1],[300,-1], wxGA_HORIZONTAL );
    $self->{'progressbar'}->SetForegroundColour ( SDBCOLOUR_LightBlue );
    $self->{'progresspercent'} = Wx::StaticText->new($self, -1, "",[-1,-1],[25,-1]);
    $self->{'progresspercent'}->SetFont( SDBFONT_NormalText ) if (!Wx::wxGTK1());
    $progresssizer->Add($self->{'progressbar'}, 1);
    $progresssizer->Add($self->{'progresspercent'}, 0, wxLEFT | wxRIGHT | wxALIGN_CENTER_VERTICAL, 10);
    $self->{'staticbox_sizer'}->Add($progresssizer, 0,wxEXPAND | wxALL, 16);

    #
    # Label
    #
    
    $self->{'text'} = Wx::StaticText->new($self,-1,'',);
    $self->{'text'}->SetFont( SDBFONT_NormalText ) if (!Wx::wxGTK1());
    $self->{'staticbox_sizer'}->Add($self->{'text'}, 0, wxLEFT | wxRIGHT | wxBOTTOM, 16);
    
    $sizer->Add($self->{'staticbox_sizer'}, 0, wxEXPAND | wxALIGN_CENTER_HORIZONTAL | wxALL, 16 );
    
    $self->SetSizerAndFit($sizer);
    $self->SetAutoLayout(1);
    $self->Layout();
    
    #Clean Progressbar?
    $self->{'progressbar'}->Update();
    
    return $self;
}


sub GetStep ($){
	defined $_[0]->GetPrevious () ? $_[0]->GetPrevious ()->GetStep () : undef; 
}


sub GetSubStep ($){
	defined $_[0]->GetPrevious () ? $_[0]->GetPrevious ()->GetSubStep () : undef; 
}


sub init{
    my ($self,$config) = @_;
       
    #Clean Progressbar?
    $self->{'progressbar'}->Update();
    
    my $app = Wx::wxTheApp ();
    my $packageManagerCollection  = $app->{'packageManagerCollection'}; 
    
    my %rv = ('auto_next' => 1);
    return \%rv;
}


sub BackInit{
    my ($self,$config) = @_;
 	
	return {'auto_back' => 1};
}


sub Process{
    my ($self,$config) = @_;
    #Clean Progressbar?
    $self->{'progressbar'}->Update();
    my $instconfig = Wx::wxTheApp ()->{instconfig};

    if (!$instconfig->CheckParams(1)){
		Wx::wxTheApp ()->ShowErrorMsg (undef, $instconfig->getErrMsgLst ());
		return undef;
	}

    #
    # Prepare
    #
    my $app = Wx::wxTheApp ();
    my $packageManagerCollection  = $app->{'packageManagerCollection'};

    $packageManagerCollection->SetProgressHandler ($self);
    $self->GetWizard()->SetRetryMode(0);
	if (!defined $app->preinstall ()){
		if ($packageManagerCollection->canResumePreinstallChecks()){
			my $auto_next = 0;
			if (defined $packageManagerCollection->{runningProcesses} && 
				%{$packageManagerCollection->{runningProcesses}}){
				my @pids;
				my @cmds;
				foreach my $pid (sort keys %{$packageManagerCollection->{runningProcesses}}){
					if (defined $packageManagerCollection->{runningProcesses}->{$pid}->{lock_check_failed}){
						push @pids,$pid;
						push @cmds,$packageManagerCollection->{runningProcesses}->{$pid}->{'commandLine'};
					}
				}
	
				if (@pids){
					my $productName = $instconfig->getProductName ();
					my $errmsg = $app->setErrorMessage ("Running processes detected. Shut down the $productName, and terminate the remaining processes.");
					my $procMsgLst = $errmsg->getSubMsgLst ();
					foreach my $i (0..$#pids){
						$procMsgLst->addMessage ("$cmds[$i] (pid=$pids[$i])");
					}
					$app->ShowErrorMsg ('Preinstallation failed', $app->getErrMsgLst());
					$packageManagerCollection->SetProgressHandler ();
					return {'errstate' => 1};
				}
				else{
					$app->ShowErrorMsg ('Preinstallation failed', $app->getErrMsgLst());
				}
			}
        	else{
        		$app->ShowErrorMsg ('Preinstallation failed', $app->getErrMsgLst());
        	}
        	
        	if ($auto_next){
        		return $self->Process ($config);
        	}
        	        	
        	$self->GetWizard()->SetRetryMode(1);
			return undef;
        }
        else{
			$app->ShowErrorMsg ('Preinstallation failed', $app->getErrMsgLst());
        }

        $packageManagerCollection->SetProgressHandler ();
        return {'errstate' => 1};
    }

    my %rv;
    return \%rv;
}


#################### Prepare start #######################

sub InitProgress{
    my ($self,$steps,$value) = @_;
    if (!defined $value){
        $self->{'progressbar'}->SetRange ($steps  + $self->{'progressbar'}->GetRange());
    }
    else{
        $self->{'progressbar'}->SetRange ($steps);
        $self->{'progressbar'}->SetValue ($value);
        $self->{progress_value} = $value;
    }
    $self->SetPercent();
    Wx::Yield ();   
}


sub IncValue ($$){
    my ($self,$value) = @_;
    $self->{progress_value} += $value;
    $self->{'progressbar'}->SetValue ($self->{progress_value});
    $self->SetPercent();
    Wx::Yield ();   
}

sub IncRange ($$){
    my ($self,$value) = @_;
    $self->{'progressbar'}->SetRange ($self->{'progressbar'}->GetRange () + $value);
    $self->SetPercent();
    Wx::Yield ();   
}



sub SetProgress ($$) {
    my ($self,$msg) = @_;
    $self->{'text'}->SetLabel ($msg);
    $self->{'progressbar'}->SetValue (++$self->{progress_value});
    $self->SetPercent();
    Wx::Yield ();   
}

sub SetPercent() {
    my ($self) = @_;
    my $value = int ($self->{'progressbar'}->GetRange() > 0 ? 
				($self->{'progressbar'}->GetValue()) / ($self->{'progressbar'}->GetRange()) * 100 :
				0);
    $self->{'progresspercent'}->SetLabel ($value .'%');
    
    1;
}

#################### Prepare end #######################


sub Back{
	my ($self) = @_;
	$self->GetWizard()->SetRetryMode(0);
	my $app = Wx::wxTheApp();
	$app->ResetPrepare ();
	return 1;
}


sub Destroy{
    my ($self) = @_;
    
    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }
    
    #
    #   Destroy other elements
    #
    foreach my $element (  
                      'progressbar',
                      'text',
                      'static_box',
                      'titel_big',
                      'progresspercent',
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
    $self->SUPER::Destroy;
}


sub DESTROY{
    my ($self) = @_;
    print ">>>> destroying $self\n"
        if $SAPDB::Install::DEBUG::DESTRUCT;
}


1;
