#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Configuration dialog => Select client or studio installation for update, 
#                               or define path for new installation 

package SDB::Install::Gui::Dialogs::SelectInstallation;

use Wx qw(wxVERTICAL wxHORIZONTAL wxEXPAND wxALL wxALIGN_TOP wxTOP wxBOTTOM wxLEFT wxRIGHT wxCB_READONLY wxALIGN_LEFT 
          wxLC_REPORT wxLC_NO_HEADER wxNO_BORDER wxLIST_FORMAT_LEFT wxOK wxCENTRE wxICON_EXCLAMATION wxBLACK);

use SDB::Install::Gui::Dialogs::GenericParameter;
use SDB::Install::Gui::Design;
use SDB::Install::SysVars qw ($isWin);
use Wx::Event qw (EVT_RADIOBUTTON EVT_COMBOBOX EVT_TEXT);

use strict;

our @ISA = qw (SAPDB::Install::Wizard::Dialog::Base);

sub new{
    my($self) = shift->SUPER::new(@_);
	my $is_gtk1 = Wx::wxGTK1 ();
    my $instconfig = Wx::wxTheApp->{'instconfig'};
    my $kit = Wx::wxTheApp->{'kit'};
	my $productname = $instconfig->getProductName();
	my $shortProductname = $instconfig->getShortProductName();
    $self->{id} = 'SelectInstallation';
	$self->{name} = "Define $shortProductname Properties";
	$self->{label_text} = "Specify $shortProductname Properties";

	# box for details, must be defined before $rsizer
	$self->{'desc_box'} = Wx::StaticBox->new($self,-1,'Installation Details');
    $self->{'desc_box'}->SetFont( SDBFONT_BoldText ) if (!$is_gtk1);
    $self->{'desc_box'}->SetForegroundColour (wxBLACK);
    $self->{'desc_box'}->Refresh (1);

    # sizers
    my $sizer = new Wx::BoxSizer(wxVERTICAL);
    my $hsizer = new Wx::BoxSizer(wxHORIZONTAL);
    my $lsizer = new Wx::BoxSizer(wxVERTICAL);
    my $rsizer = new Wx::StaticBoxSizer($self->{'desc_box'},wxVERTICAL);

	# title
    $self->{'titel'} = new Wx::StaticText($self,-1,'Choose an installation to update, or choose a path for a new installation',[0,0],[-1,-1]);
    $self->{'titel'}->SetFont( SDBFONT_DialogTitle ) if (!Wx::wxGTK1());
    $sizer->Add($self->{'titel'},0,wxLEFT | wxRIGHT | wxTOP | wxBOTTOM ,20);
    $sizer->AddSpacer(12);

	# radio button for update
    $self->{'rb_update'} = new Wx::RadioButton($self,-1,"Update $productname",[0,0],[-1,-1]);
    $self->{'rb_update'}->SetFont( SDBFONT_NormalText ) if (!$is_gtk1);
    $lsizer->Add($self->{'rb_update'},0,wxLEFT | wxRIGHT, 20);
    $lsizer->AddSpacer(12);
	EVT_RADIOBUTTON ($self, $self->{'rb_update'}->GetId(), \&OnRBUpdate);

	# combo box for existing installations
	$self->{'cb_installations'} = new Wx::ComboBox($self, -1, '', [-1,-1], [-1,-1], [], wxCB_READONLY);
    $self->{'cb_installations'}->SetFont( SDBFONT_NormalText ) if (!$is_gtk1);
    $self->{'cb_installations'}->SetMinSize(new Wx::Size(200, -1));
    $self->{'cb_installations'}->SetSize(new Wx::Size(200, -1));
    $lsizer->Add($self->{'cb_installations'},0 , wxLEFT, 40);
    $lsizer->AddSpacer(30);
    EVT_COMBOBOX ($self, $self->{'cb_installations'}->GetId(), \&OnSelectCbInstallations);

	# radio button for new installation
    $self->{'rb_install'} = new Wx::RadioButton($self,-1,"Install new $productname",[0,0],[-1,-1]);
    $self->{'rb_install'}->SetFont( SDBFONT_NormalText ) if (!$is_gtk1);
    $lsizer->Add($self->{'rb_install'},0,wxLEFT | wxRIGHT, 20);
    $lsizer->AddSpacer(12);
	EVT_RADIOBUTTON ($self, $self->{'rb_install'}->GetId(), \&OnRBInstall);

	# path control for new installation
	$self->{'pc_path'} = new SAPDB::Install::Control::PathCtrl ($self,-1,'', [-1,-1], [-1,-1]);
    $self->{'pc_path'}->SetMinSize ([200,-1]);
    $lsizer->Add($self->{'pc_path'},0,wxLEFT, 40);
    $lsizer->AddSpacer(12);
    EVT_TEXT ($self,$self->{'pc_path'}->GetId(), \&OnPCPathEnter);

	$self->addAdditionalUICtrlsLeft($lsizer);

	# heading for detailList
    $self->{'detailLabel'} = new Wx::StaticText($self,-1,' ',[0,0],[-1,-1]);
    $self->{'detailLabel'}->SetFont( SDBFONT_DialogTitle ) if (!Wx::wxGTK1());
	$rsizer->Add($self->{'detailLabel'},0,wxLEFT ,10);

	# list box for details
	$self->{'detailList'} = new Wx::ListCtrl($self, -1, [0,0], [-1,-1], wxLC_REPORT | wxLC_NO_HEADER | wxNO_BORDER);
    $self->{'detailList'}->SetFont( SDBFONT_NormalText ) if (!$is_gtk1);
	$self->{'detailList'}->InsertColumn(1, "Parameter", wxLIST_FORMAT_LEFT, -1);
	$self->{'detailList'}->InsertColumn(2, "Value1", wxLIST_FORMAT_LEFT, -1);
	$self->{'detailList'}->InsertColumn(3, "Value2", wxLIST_FORMAT_LEFT, -1);
	$rsizer->Add($self->{'detailList'},0,wxEXPAND | wxLEFT, 10);

	# label for displaying installation path
    $self->{'pathLabel'} = new Wx::StaticText($self,-1,' ',[0,0],[-1,-1]);
    $self->{'pathLabel'}->SetFont( SDBFONT_NormalText ) if (!$is_gtk1);
    $rsizer->Add($self->{'pathLabel'},0, wxLEFT ,10);
	
	# arrange sizers
	$hsizer->Add($lsizer, 0, wxALIGN_LEFT);
    $hsizer->AddSpacer(100);
	$hsizer->Add($rsizer, 1, wxALIGN_LEFT | wxEXPAND | wxBOTTOM | wxRIGHT, 16);
	$sizer->Add($hsizer, 1, wxALIGN_TOP  | wxEXPAND);
	
	$self->addAdditionalUICtrlsBottom($sizer); 
		
	$self->SetSizer($sizer);
	$self->SetAutoLayout (1);
    return $self;
}

sub init{
	my ($self,$config) = @_;
	my $app = Wx::wxTheApp ();
	my ($instconfig, $kit) = (
		$app->{instconfig},
		$app->{kit}
	);

	my @kitData = ($kit->GetVersion(), $kit->is64bit() ? '64bit' : '32bit');
	$self->{kitData} = \@kitData;

	$instconfig->InitDefaults ($kit);

	# set parameters from cfg file and cmdln args 
	$self->{checkmsg} = $app->getMsgLst()->addMessage ("Checking configuration of installation (dialog $self->{name})");
	$self->{checkmsg}->setEndTag ('Configuration Check');
	$instconfig->setMsgLstContext ([$self->{checkmsg}->getSubMsgLst()]);
	my $rc = $instconfig->CheckParams ($app->{batch_mode});
	if($self->{batch_mode}){
		if (!$rc){
			if (defined $rc){
				$app->setErrorMessage ("running in batch mode", $instconfig->getErrMsgLst ());
				$app->PrintUsage ();
			}
			else{
				$app->setErrorMessage (undef, $instconfig->getErrMsgLst ());
			}
			return undef;
		}
	}

	# report errors
	if ($instconfig->ErrorState){
		$self->GetWizard ()->LayoutDlg ();
		if (defined $SDB::Wx::Splash::Window){
			$SDB::Wx::Splash::Window->Close();
			undef $SDB::Wx::Splash::Window;
		}
		$app->ShowErrorMsg ('Initialize configuration failed', $instconfig->getErrMsgLst ());
		return {'errstate' => 1};
	}

	my ($tab, $default, $result);
	# path not pre-defined?
    if (!$instconfig->isInstallationSelected ()){
		# determine existing installations
    	$result = $self->getInstallationsForUpdate ($instconfig);
	    if (!defined $result) {
			return undef;
	    }
	    ($tab,$default) = @$result;
	}
	else {
		# path pre-defined, exit dialog
		return {'auto_next' => 1};
	}

	my $configDefault = $instconfig->get_InstallationPathDefault();
	my $configDefaultUsed = 0;
		
	# if no installations exist
	if (!defined $tab) {
		$default = $configDefault;
	}
	
	# if installations exist
	if (defined $tab && @$tab){
		# add existing installations to combobox and detail list
		foreach my $row (@$tab){
			$self->{'cb_installations'}->Append($row->[0]);
			if ($row->[0] eq $configDefault) {
				$configDefaultUsed = 1;
			}
		}
		if (defined $default) {	
			$self->{'cb_installations'}->SetValue($default);
			my $index;
			foreach my $i (0 .. (scalar (@$tab) - 1)) {
				if ($tab->[$i]->[0] eq $default) {
					$index = $i;
					last;
				}
			}
			$self->DisplayDetails($tab->[$index], 1);
			$self->{'rb_update'}->SetValue(1);
			$self->{'pc_path'}->Enable(0);
		} else {
			$self->{'cb_installations'}->SetValue($tab->[0]->[0]);
			$self->{'rb_install'}->SetValue(1);
			$self->{'pc_path'}->Enable(1);
			$self->{'cb_installations'}->Enable(0);
			$self->DisplayDetails([], 0);
		}
		# set path control to default from configuration only if 
		# path is not already used by existing installation
		if (!$configDefaultUsed) {
			$self->{'pc_path'}->SetValue($configDefault);
		}
	}
	else{
		# insert default into path control and details list
		$self->{'pc_path'}->SetValue($default);
		$self->DisplayDetails([], 0);
		$self->{'rb_install'}->SetValue(1);
		$self->{'rb_update'}->Enable(0);
		$self->{'cb_installations'}->Enable(0);
	}

	# try to fix broken (too short) layout of pc_path on Linux
	$self->{'cb_installations'}->InvalidateBestSize();
	$self->{'cb_installations'}->SetBestFittingSize();

    $self->Layout();
	return {};

}

sub BackInit {
    my ($self, $config) = @_;
	my $instconfig = Wx::wxTheApp->{'instconfig'};
	$instconfig->resetParam('PATH');
    return {};
}

sub Process{
	
	# NEXT button was pressed on dialog
	
	my ($self,$config) = @_;

	my $instconfig = Wx::wxTheApp()->{instconfig};

    my $returnHash = {};

    if ($instconfig->isInstallationSelected ()){
        $returnHash->{'mode'} = $instconfig->isUpdate() ? 'update' : 'install';
        return $returnHash;
    }

	my $path;
	if ($self->{'rb_update'}->GetValue()) {
		# update existing installation
		$path = $self->{'cb_installations'}->GetValue();
		$returnHash->{'mode'} = 'update';
	}
	else {
		# new installation
		$path = $self->{'pc_path'}->GetValue();
		$returnHash->{'mode'} = 'install';
	}
	
	if (!$instconfig->set_InstallationPath ($path)){
		Wx::MessageBox($instconfig->GetErrorString (), "Configuration Error",
		 wxOK | wxCENTRE | wxICON_EXCLAMATION, $self );
		 $instconfig->ResetError ();
		 return undef;
	}

	if ($returnHash->{'mode'} eq 'update') {
		$instconfig->setUpdateParams();
	}

	return $returnHash;
}

# event handler for rb_update
sub OnRBUpdate{
	my ($self, $evt) = @_;
	$self->{'pc_path'}->Enable (0);
	$self->{'cb_installations'}->Enable (1);
	my $index = $self->{'tab'}->[$self->{'cb_installations'}->GetSelection()];
	$self->DisplayDetails($index, 1);
}

# event handler for rb_install
sub OnRBInstall{
	my ($self, $evt) = @_;
	$self->{'pc_path'}->Enable (1);
	$self->{'cb_installations'}->Enable (0);
	$self->DisplayDetails([], 0);
}

# event handler for cb_installations
sub OnSelectCbInstallations{
	my ($self, $evt) = @_;
	my $index = $self->{'tab'}->[$evt->GetInt()];
	$self->DisplayDetails($index, 1);
}

# event handler for pc_path
sub OnPCPathEnter{
	my ($self, $evt) = @_;

    if ($self->{'rb_install'}->GetValue()) {
       $self->{'pathLabel'}->SetLabel("  Installation path: " . $self->{'pc_path'}->GetValue());
    }
}

sub DisplayDetails {
	
	# update detail information to match currently chosen installation
	
	my ($self, $index, $update) = @_;
	my $is_gtk1 = Wx::wxGTK1 ();

	if ($update) {
		$self->{'detailList'}->DeleteAllItems();

		my $count = 0;
		my $item;

		# heading
		$item = $self->{'detailList'}->InsertStringItem($count++,"");
		$self->{'detailList'}->SetItem($item,1,"Installed");
		$self->{'detailList'}->SetItem($item,2,"New");
		if (!$is_gtk1) {
			my $tmpItem = $self->{'detailList'}->GetItem($item);
			$tmpItem->SetFont(SDBFONT_BoldText);
			$self->{'detailList'}->SetItem($tmpItem);
		}

		$item = $self->{'detailList'}->InsertStringItem($count++,"Version: ");
		$self->{'detailList'}->SetItem($item,1,$index->[1]);
		if ($self->{kitData}->[0]) {
			$self->{'detailList'}->SetItem($item,2,$self->{kitData}->[0]);	
		}

		$item = $self->{'detailList'}->InsertStringItem($count++,"Mode: ");
		if (defined $index->[2]) {
			$self->{'detailList'}->SetItem($item,1,$index->[2]);
		}
		if ($self->{kitData}->[1]) {
			$self->{'detailList'}->SetItem($item,2,$self->{kitData}->[1]);	
		}

		$self->{'pathLabel'}->SetLabel("  Installation path: " . $self->{'cb_installations'}->GetValue());
	}
	else {  # new installation

		$self->{'detailList'}->DeleteAllItems();

		my $count = 0;
		my $item;

		# heading
		$item = $self->{'detailList'}->InsertStringItem($count++,"");
		$self->{'detailList'}->SetItem($item,1,"To be installed");
		my $titleCol = Wx::ListItem->new();
		$titleCol->SetText("To be installed");
		$self->{'detailList'}->SetColumn(1, $titleCol);

		if (!$is_gtk1) {
			my $tmpItem = $self->{'detailList'}->GetItem($item);
			$tmpItem->SetFont(SDBFONT_BoldText);
			$self->{'detailList'}->SetItem($tmpItem);
		}

		$item = $self->{'detailList'}->InsertStringItem($count++,"Version: ");
		if ($self->{kitData}->[0]) {
			$self->{'detailList'}->SetItem($item,1,$self->{kitData}->[0]);	
		}

		$item = $self->{'detailList'}->InsertStringItem($count++,"Mode: ");
		if ($self->{kitData}->[1]) {
			$self->{'detailList'}->SetItem($item,1,$self->{kitData}->[1]);	
		}
		
		$self->{'pathLabel'}->SetLabel("  Installation path: " . $self->{'pc_path'}->GetValue());
	}

	$self->{'detailList'}->SetColumnWidth(0, -1);
	$self->{'detailList'}->SetColumnWidth(1, -1);
	$self->{'detailList'}->SetColumnWidth(2, -1);
}

sub getInstallationsForUpdate{
	
	# returns list of existing installations, and default suggestion for update
	
	my ($self,$instconfig) = @_;
	my $kit = Wx::wxTheApp->{'kit'};
	my $installations = $instconfig->enumExistingInstallations ();
	my $shortProductname = $instconfig->getShortProductName ();
	
	my @tab;
	$self->{tab} = \@tab;

	if (!defined $installations){
		$self->setErrorMessage (undef , $instconfig->getErrMsgLst ());
		return [];
	}	
	
	if (!keys %$installations){
		return [];
	}
	
	my $modeAvailable = 0;
	my $default;
	my $date;
	my @stat;
    foreach my $p (keys %$installations){
        if ($installations->{$p}->{mode}) {
        	$modeAvailable = 1;
        }
        if (!$installations->{$p}->{canUpdate}) {
        	next;
        }
    	@stat = stat ($p);
    	if (@stat){
    		if (!defined $date || $date < $stat[10]) {
   				$date = $stat[10];
   				$default = $p;
    		}
      	}
    }

    foreach my $path (sort keys %$installations){
		if ($modeAvailable) {
    	    push @tab, [$path, $installations->{$path}->{version}, $installations->{$path}->{mode}];
		} else {
    	    push @tab, [$path, $installations->{$path}->{version}];
		}
    }

	return [\@tab, $default];
}

sub addAdditionalUICtrlsLeft{}
sub addAdditionalUICtrlsBottom{}

1;
