#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: User dialog for updating database or software only.

package SDB::Install::Gui::Dialogs::SelectUpdate;

use Wx qw (
    wxVERTICAL
    wxHORIZONTAL
    wxEXPAND
	wxALL
    wxLEFT
    wxRIGHT
    wxBOTTOM
    wxALIGN_CENTER_VERTICAL
    wxCB_READONLY
    wxCB_SORT
    wxCB_DROPDOWN
    wxLC_REPORT
    wxICON_EXCLAMATION
    wxBLACK
    wxLC_NO_HEADER
    wxNO_BORDER
    wxCENTRE
    wxOK
    );

use Wx::Event qw (
     EVT_COMBOBOX
    );

use SAPDB::Install::Wizard::Dialog::Base;
use SDB::Install::Gui::Dialogs::Preparing;
use SDB::Install::Gui::Dialogs::Install;
use SDB::Install::Configuration::Upgrade;
use SDB::Install::Gui::Design; 
use SDB::Install::Globals;
use SDB::Install::SAPSystem;

our @ISA = qw (SAPDB::Install::Wizard::Dialog::Base);



sub new{
	my($self ) = shift->SUPER::new(@_);
	
	$self->{id} = 'SelectUpdate';
		
	$self->{name} = 'Select Installation';
   
	my $is_gtk1 = Wx::wxGTK1 ();
   
   
    #
    #   Sizer
    # 
    
    my $lsizer = Wx::BoxSizer->new(wxVERTICAL);
    
    
    $lsizer->AddSpacer(20);
    
    
    $self->{show_self_defined} = 1;
     
                
    #
    #   Title
    #


	my $topsizer = new Wx::BoxSizer (wxVERTICAL);
	

	$self->{'title'} = Wx::StaticText->new($self,-1,"Select the system to be upgraded ",[0,0],[-1,-1]);
	$self->{'title'}->SetFont( SDBFONT_DialogTitle ) if (!$is_gtk1);

	$topsizer->Add ($self->{'title'},0, (wxALL) & (~wxBOTTOM), 16);

	$self->{'sw_sizer'} = Wx::BoxSizer->new(wxHORIZONTAL);
	$self->{'swchoice_label'} = Wx::StaticText->new( $self, -1, "System Id:", [-1,-1]);
	$self->{'swchoice_label'}->SetFont ( SDBFONT_NormalText ) if (!$is_gtk1);
	$self->{'swchoice_combobox'} = Wx::ComboBox->new( $self, -1,
		"" ,
		[-1,-1], [160,-1], [], wxCB_READONLY | wxCB_SORT | wxCB_DROPDOWN );
	$self->{'sw_sizer'}->Add($self->{'swchoice_label'},0, wxALIGN_CENTER_VERTICAL );
	$self->{'sw_sizer'}->Add($self->{'swchoice_combobox'},0,  wxLEFT | wxRIGHT,10);

	EVT_COMBOBOX($self,$self->{'swchoice_combobox'}->GetId (), \&OnSelectSW);

	$lsizer->Add($self->{'sw_sizer'},0, wxLEFT , 38);
	
        $lsizer->AddSpacer(12);


	
    #
    #   Description
    #
    
	$self->{'desc_box'} = Wx::StaticBox->new($self,-1,'Installation Details');
    $self->{'desc_box'}->SetFont( SDBFONT_BoldText ) if (!$is_gtk1);
    $self->{'desc_box'}->SetForegroundColour (wxBLACK);
    $self->{'desc_box'}->Refresh (1);
	$self->{'box_sizer'} = Wx::StaticBoxSizer->new($self->{'desc_box'},wxVERTICAL);	

	$self->{'list'} = Wx::ListCtrl->new( $self, -1, [0,0],[-1,-1], wxLC_REPORT | wxLC_NO_HEADER | wxNO_BORDER);
	$self->{'list'}->InsertColumn( 1, "Parameter" );
	$self->{'list'}->InsertColumn( 2, "Value" );
	
	
    $self->{'list'}->SetFont( SDBFONT_NormalText ) if (!$is_gtk1);
	$self->{'box_sizer'}->Add($self->{'list'},1,wxEXPAND | wxALL ,10);
	$self->{'desc_sizer'} = Wx::BoxSizer->new(wxVERTICAL);
    $self->{'desc_sizer'}->Add($self->{'box_sizer'},1,wxEXPAND | wxLEFT ,16);
    
    
    my $sizer = new Wx::BoxSizer (wxHORIZONTAL);
    $sizer->Add ($lsizer,1,wxEXPAND);
    $sizer->Add($self->{'desc_sizer'},1,wxEXPAND);  

    $topsizer->Add ($sizer,1,wxEXPAND | wxALL, 16);
    
    #
    #   Dialog stuff
    #
    
    $self->SetSizerAndFit($topsizer);
    $self->SetAutoLayout(1);
   
	return $self;
}


sub SelectEntry{
	my ($self,$entry) = @_;
	
	if (!defined $entry){
		$entry = $self->{'swchoice_combobox'}->GetValue();
	}
	
	if (!defined $entry){
		return; 
	}
	my $systems = CollectSAPSystems ();
	
	my $sys = $self->{sapSystem} = $systems->{$entry};

	if (!defined $self->{sapSystem}){
		return undef;
	}


	#
    #   Setup detail list
    #
    
	$self->{'list'}->DeleteAllItems;
	
	my $count = 0;
	my $item = $self->{'list'}->InsertStringItem($count++,"System Id");
	$self->{'list'}->SetItem($item,1,$sys->get_sid);

	$item = $self->{'list'}->InsertStringItem($count++,"Instance Number");
	
	my $instances = $sys->getNewDBInstances ();
	my $instance;
	if (defined $instances && defined $instances->[0]){
		$instance = $instances->[0];
	}
	
	$self->{'list'}->SetItem($item,1,defined $instance ? $instance->{_nr} : '<unknown>');
		
	$item = $self->{'list'}->InsertStringItem($count++,"Version");
	$self->{'list'}->SetItem($item,1,$sys->GetVersion());

	#$item = $self->{'list'}->InsertStringItem($count++,"IntegratedSystem");
	#$self->{'list'}->SetItem($item,1,$sys->get_integratedSystem ? 'YES' : 'NO');
	
	#$item = $self->{'list'}->InsertStringItem($count++,"GlobalSidDir");
	#$self->{'list'}->SetItem($item,1,$sys->get_globalSidDir);
	
	#$item = $self->{'list'}->InsertStringItem($count++,"SystemCocktail");
	#$self->{'list'}->SetItem($item,1,new SystemCocktail ($sys->{_systemCocktail})->getStringType());
	

	if ($sys->get_integratedSystem()){
		$item = $self->{'list'}->InsertStringItem($count++,"Instance Types");
		$self->{'list'}->SetItem($item,1,join (', ', @{$sys->getTypeList()}));
	}
	
	foreach my $instance (values %{$sys->{_instances}}){
		if ($instance->isNewDB()){
			$item = $self->{'list'}->InsertStringItem($count++,"Instance Directory");
			$self->{'list'}->SetItem($item,1,$instance->{_instanceDir});
			$item = $self->{'list'}->InsertStringItem($count++,"Hosts");
			$self->{'list'}->SetItem($item,1,join (', ', @{$instance->getAllHostsWithRoles(1)}));

			my $pluginInstallations = $instance->getPluginInstallations();
			my @pluginKeys;
			my $plugins;
			if (defined $pluginInstallations && @$pluginInstallations){
				foreach my $inst (@$pluginInstallations){
					push @pluginKeys, $inst->getProductKey();
				}
				$plugins .= join(', ', @pluginKeys) if (@pluginKeys);
			}
			if ($plugins) {
				$item = $self->{'list'}->InsertStringItem($count++,"Plugins");
				$self->{'list'}->SetItem($item,1,$plugins);
			}
		}
	}
	
	if (defined $self->{nonproper}->{$entry}){
		$item = $self->{'list'}->InsertStringItem($count++,"Upgrade denied");
	$self->{'list'}->SetItem($item,1,$self->{nonproper}->{$entry});
	
	}

	
	
	$self->{'list'}->SetColumnWidth(0,-1);
	if ($^O =~ /mswin/i){
		$self->{'list'}->SetColumnWidth(1,-2);
	}
	else{
		$self->{'list'}->SetColumnWidth(1,-1);
	}
	
}

sub OnSelectSW{
	my ($self,$evt) = @_;
	$self->SelectEntry ($evt->GetString);
}

sub init(){
	my ($self,$config) = @_;
	my @softwarechoicelist;
	
	my $app = Wx::wxTheApp();
	my $kit = $app->{kit};
	my $instconfig = $app->{instconfig};

	my $systems = CollectSAPSystems();
		
	my $msglst = new SDB::Install::MsgLst ();
		
	SDB::Install::SAPSystem::dumpSapSystems (undef, $msglst);
		
	$app->getMsgLst ()->appendMsgLst ($msglst);
		
	my $id = 0;
	my @tab;
	my $system;
	my ($proper,$nonproper) = $instconfig->getProperSIDs ();
	
	my %nonproper;

	$self->{nonproper} = \%nonproper;

	foreach my $sid (@$nonproper){
		$nonproper{$sid->[0]} = $sid->[1];
	}
	
	foreach my $sid (sort (@$proper,@$nonproper)){
		$self->{'swchoice_combobox'}->Append ($sid->[0]);
	}

	$self->Show (1);
	$self->GetWizard->LayoutDlg();

	if ($^O =~ /mswin/i){
	$self->{'list'}->SetColumnWidth(1,-2);
	}

    $instconfig->CheckParams ($app->{batch_mode});

	if ($instconfig->ErrorState()){
        $app->ShowErrorMsg ('Configuration Error', $instconfig->getErrMsgLst ());
	}

	my $sid = $instconfig->getBatchValue ('SID');
	if (defined $sid){
		$self->{'swchoice_combobox'}->SetValue ($sid);
		$self->SelectEntry ();
		return {'auto_next' => 1};
	}
	$sid = $instconfig->getDefault('SID');

	if (!$sid){
		$sid = $self->{'swchoice_combobox'}->GetString (0);
	}
	$self->{'swchoice_combobox'}->SetValue ($sid);
	$self->SelectEntry ();
	return {};
}

sub Process{
	my ($self,$config) = @_;

	my $instconfig = Wx::wxTheApp()->{instconfig};
	
	if (defined $instconfig->getValue ('SID')){
		return {};
	}
	
	my $value = $self->{'swchoice_combobox'}->GetValue();

	if (defined $self->{nonproper}->{$value}){
		Wx::MessageBox($self->{nonproper}->{$value} , "Upgrade denied",
		 wxOK | wxCENTRE | wxICON_EXCLAMATION, $self );
		return undef;
	}

	if (!$instconfig->setValue ('SID',$value)){
	
		Wx::MessageBox($instconfig->GetErrorString (), "Configuration Error",
		 wxOK | wxCENTRE | wxICON_EXCLAMATION, $self );
		 return undef;
	}
	return {};
}

sub BackInit{
    my ($self,$config) = @_;
    my $instconfig = Wx::wxTheApp()->{instconfig};
    $instconfig->Reset();
    $instconfig->InitDefaults();
	return {};
}

sub Back{
	my ($self,$config) = @_;
	
	my $app = Wx::wxTheApp();
	$app->ResetConfiguration ();
	
	if (defined $config->{updateInstallation}){
		$config->{updateInstallation}->FreePackages ();
		delete $config->{updateInstallation};
	}
	
	if (!defined $self->{instkey_tab}){
		return 1;
	}
	
	foreach my $entry (%{$self->{instkey_tab}}){
			if (defined $self->{instkey_tab}->{$entry}->{inst}){
				$self->{instkey_tab}->{$entry}->{inst}->FreePackages ();
				undef $self->{instkey_tab}->{$entry}->{inst};
			}
	}
	$self->GetWizard->ResetCondensedStep ('update_properties');
	$self->GetWizard->ResetCondensedStep ('install');
	if (exists $config->{'updatemode'}) { delete $config->{'updatemode'};}
	return 1;
}

sub Destroy{
	my ($self) = @_;
    
    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

    #
    #   Destroy other elements
    #
    foreach my $element (  'title',
						'list',
                        'swchoice_label',
                        'swchoice_combobox',
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;
