#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 

package SDB::Install::Gui::Dialogs::Uninstallation::PackageProgressHandler;

use base SDB::Install::ProgressHandler;

sub new{
    my $self = shift->SUPER::new;
    ($self->{plan}) = @_;
    return $self;
}

sub InitProgress($$$){
    my ($self,$steps,$value) = @_;
    $self->{range} = $steps;
    $self->{value} = $value;
    
    if ($self->{range}){
        $value = int(100 * $self->{value} / $self->{range});
    }
    else{
        $value = 100;
    }
    $self->{plan}->SetProgress($value);
    Wx::Yield ();   
}

sub SetProgress ($$) {
    my ($self,$msg) = @_;
    $self->{value}++;
    my $value;

    if ($self->{range}){
        $value = int(100 * $self->{value} / $self->{range});
    }
    else{
		$value = 100;
    }

    $self->{plan}->SetProgress($value);
    Wx::Yield ();   
}

1;

##################################

package SDB::Install::Gui::Dialogs::Uninstallation;

use Wx::Event qw (
                  );

use Wx qw ( 
        wxEXPAND
        wxTOP
        wxALIGN_CENTER wxALL
        wxLEFT
        wxVERTICAL
        wxSUNKEN_BORDER
          );

use SDB::Install::Gui::Design;
use SAPDB::Install::Wizard::Dialog::Base;
use SAPDB::Install::Window::ExecPlan;
use SDB::Install::PackageManagerCollection;
use SDB::Install::SysVars qw($isWin);

our @ISA = qw (SAPDB::Install::Wizard::Dialog::Base);

sub new{
	my($self ) = shift->SUPER::new(@_);
    $self->{id} = 'uninstall';
    $self->{name} = 'Uninstall'; 
    
    my $text = "Uninstalling software components";
	$self->{'caption'} = Wx::StaticText->new($self,-1,$text,[0,0],[-1,-1]);
	$self->{'caption'}->SetFont (SDBFONT_DialogTitle) if (!Wx::wxGTK1());
    
    my $top_sizer = Wx::BoxSizer->new(wxVERTICAL);
    $self->{'plan'} = SAPDB::Install::Window::ExecPlan->new($self,-1);
    $top_sizer->Add($self->{'caption'},0,wxALIGN_LEFT | wxLEFT | wxTOP , 20);
    $top_sizer->Add($self->{'plan'},1,wxALL | wxEXPAND, 20);
    $self->SetSizer($top_sizer);
    $self->SetAutoLayout(1);
    $self->Layout;
    $self->{'plan'}->Show(1);
    $self->{'plan'}->Refresh(1);
    $self->{'plan'}->Update;
    return $self;
}


sub init(){
	my ($self,$config) = @_;

	my $app = Wx::wxTheApp ();
    my $installation = $app->{installation};
    $self->{'caption'}->SetLabel ("Uninstalling " . $installation->asString());


    return {'auto_next' => 1}; 
}

sub Process{
	my ($self,$config) = @_;
    my @steps;
	$self->GetWizard()->KillPreviousDialogs();
    my $app = Wx::wxTheApp ();
    my $instconfig = $app->{instconfig};

    if ($isWin){
        new SAPDB::Install::Resources()->CloseArchive ();
    }

   my $installation = $app->{installation};
   my $msg = $app->getMsgLst()->addMessage ("Removing installation");
   $installation->setMsgLstContext ([$msg->getSubMsgLst ()]);
   if (!defined $installation->OpenExclusive()){
     $app->ShowErrorMsg  ('cannot open registry exclusively', $installation->getErrMsgLst());
     return undef;
   }
   my $packages = $installation->GetPackages();
   my $name = $installation->getProductName ();
   if (!$installation->ErrorState){
       foreach my $package (reverse @{$packages}){
            push @steps, {'Label' => $package->GetName() , 'State' => 'PENDING'};
       }
   }
    $self->{plan}->init(\@steps,{'with_progress' => 1});
    $self->Layout ();
    my $pp_handler = new SDB::Install::Gui::Dialogs::Uninstallation::PackageProgressHandler ($self->{plan});
    $installation->SetProgressHandler ($self);
    $installation->SetPackageProgressHandler ($pp_handler);
    my $rc = $installation->Uninstall(undef, $instconfig->getValue ('Force'), $instconfig, 0);
    $msg->endMessage ();
    if (!defined $rc){
         $app->ShowErrorMsg ('Uninstallation failed', $installation->getErrMsgLst());
         return  {'error_state' => 1};   
    } 
	return {};
}

sub InitProgress($$$$){
    my ($self,$steps,$value,$names) = @_;
    
    return 1;
    
    my @steps;
    
    
    foreach my $name (@$names){
        push @steps, {'Label' => $name, 'State' => 'PENDING'};
    }
        
    $self->{'plan'}->init(\@steps,{'with_progress' => 1});
    $self->Layout ();
    Wx::Yield ();   
}


sub IncValue ($$){
    my ($self,$value) = @_;
    Wx::Yield ();   
}

sub IncRange ($$){
    my ($self,$value) = @_;
    Wx::Yield ();   
}


sub SetProgress ($$) {
    my ($self,$msg) = @_;
    Wx::Yield ();   
}


sub StepFinished{
    my ($self,$error) = @_;
    
    if ($error){
    	$self->{'plan'}->Next('FINISHED_ERROR');
    }
	else{
		
		$self->{'plan'}->SetProgress (100);
		$self->{'plan'}->Next ('FINISHED_SUCCESS');
    }
} 

sub Destroy{
	my ($self) = @_;
	
    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

    #
    #   Destroy elements
    #
    foreach $element (  
                        'plan',
                        'caption'
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
    
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}


1;
